// src/utils/getTemplate.ts
import GLib from "gi://GLib";
var getTemplate = (name) => {
  const uri = GLib.uri_resolve_relative(
    import.meta.url,
    `ui/${name}.ui`,
    GLib.UriFlags.NONE
  );
  if (uri === null) {
    throw new Error(`Failed to resolve URI for template ${name}!`);
  }
  return uri;
};
export {
  getTemplate
};
