import Adw from "gi://Adw";
import Gio from "gi://Gio";
import Gtk from "gi://Gtk";

import { ExtensionPreferences } from "resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js";

export default class InPicturePreferences extends ExtensionPreferences {
  fillPreferencesWindow(window) {
    window.settings = this.getSettings();

    const builder = Gtk.Builder.new_from_file(this.path + "/prefs.ui");
    const page = builder.get_object("preferences_page");
    window.add(page);

    /* Position */
    const cornerRow = builder.get_object("corner_row");
    cornerRow.selected = window.settings.get_int("corner");
    cornerRow.connect("notify::selected", () => {
      window.settings.set_int("corner", cornerRow.get_selected());
    });

    /* Diagonal */
    const diagonalAdjustment = builder.get_object("diagonal_adjustment");
    diagonalAdjustment.value = window.settings.get_int("diagonal");
    diagonalAdjustment.connect("value-changed", () => {
      window.settings.set_int("diagonal", diagonalAdjustment.get_value());
    });

    /* Margins */
    const marginXAdjustment = builder.get_object("margin_x_adjustment");
    marginXAdjustment.value = window.settings.get_int("margin-x");
    marginXAdjustment.connect("value-changed", () => {
      window.settings.set_int("margin-x", marginXAdjustment.get_value());
    });

    const marginYAdjustment = builder.get_object("margin_y_adjustment");
    marginYAdjustment.value = window.settings.get_int("margin-y");
    marginYAdjustment.connect("value-changed", () => {
      window.settings.set_int("margin-y", marginYAdjustment.get_value());
    });

    /* Visibility */
    const stayOnTopRow = builder.get_object("stay_on_top_row");
    window.settings.bind(
      "top",
      stayOnTopRow,
      "active",
      Gio.SettingsBindFlags.DEFAULT
    );

    /* Titles */
    const titlesAdd = builder.get_object("titles_add");
    titlesAdd.connect("clicked", titlesListAdd);

    const titlesList = builder.get_object("titles_list");
    titlesListPopulate();

    function titlesListPopulate() {
      titlesList.remove_all();

      const titlesStrings = window.settings.get_strv("titles");
      for (const title of titlesStrings) {
        const titleRow = new Adw.ActionRow({
          title: title,
          selectable: false,
          activatable: true,
        });
        titlesList.append(titleRow);

        const deleteButton = new Gtk.Button({
          icon_name: "user-trash-symbolic",
          valign: Gtk.Align.CENTER,
        });
        titleRow.add_suffix(deleteButton);
        deleteButton.add_css_class("circular");
        deleteButton.add_css_class("flat");
        deleteButton.connect("clicked", () => {
          window.settings.set_strv(
            "titles",
            titlesStrings.filter((t) => t !== title)
          );
          titlesListPopulate();
        });
      }
    }

    function titlesListAdd() {
      const titlesDialog = new Adw.AlertDialog({
        heading: "Add PiP Title",
        body: "Enter a new window title to recognize:",
      });
      titlesDialog.add_response("cancel", "Cancel");
      titlesDialog.add_response("add", "Add");
      titlesDialog.set_response_appearance(
        "add",
        Adw.ResponseAppearance.SUGGESTED
      );

      const titlesDialogEntry = new Gtk.Entry();
      titlesDialog.set_extra_child(titlesDialogEntry);
      titlesDialog.connect("response", (dialog, response) => {
        if (response === "add") {
          const title = titlesDialogEntry.text.trim();
          if (title.length > 0) {
            const titles = window.settings.get_strv("titles");
            if (!titles.includes(title)) {
              titles.push(title);
              window.settings.set_strv("titles", titles);
              titlesListPopulate();
            }
          }
        }

        dialog.close();
      });

      titlesDialog.present(page);
    }
  }
}
