import Adw from 'gi://Adw';
import Gtk from 'gi://Gtk';
import Gio from 'gi://Gio';
import Gdk from 'gi://Gdk';
import GObject from 'gi://GObject';
import { ExtensionPreferences } from 'resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js';

import { Str, getPrayTimeSetting } from './otherFunctions.js';
import PrayTimes from './PrayTimes.js';
import * as Tarikh from './Tarikh.js';
import * as Cities from './cities.js';
import * as sound from './sound.js';

export default class ShamsiCalendarPreferences extends ExtensionPreferences {
  fillPreferencesWindow(window) {
    window.set_default_size(680, 570);
    new App(window, this.getSettings(), this.path);
  }
}

class App extends Adw.PreferencesPage {
  static {
    GObject.registerClass(this);
  }

  constructor(window, schema, path) {
    super();
    this.schema = schema;
    this.el = {};
    this.NewPrayTimes = new PrayTimes();
    let _dateObj = new Tarikh.TarikhObject();
    let sensitiveFunc, hbox;

    const showFormats = [
      '%WW',
      '%d',
      '%d %MM',
      '%WW %d',
      '%WW %d %MM',
      '%WW %d %MM %Y',
      '%WW %d %MM %y',
      '%WW %d / %MM / %Y',
      '%WW %d / %m / %Y',
      '%WW %d / %MM / %y',
      '%WW %d / %m / %y',
      '%d / %MM / %Y',
      '%d / %MM / %y',
      '%d %MM %Y',
      '%d %MM %y',
      '%WW %d / %m / %Y (%MM)',
      '%d / %m / %Y (%MM)',
    ];

    // icons list: https://github.com/StorageB/icons/blob/main/GNOME48Adwaita/icons.md
    [
      ['vbox1', 'ابزارک نوار', 'user-home-symbolic'],
      ['vbox2', 'پنجره تقویم', 'preferences-desktop-appearance-symbolic'],
      ['vbox3', 'مناسبت‌ها', 'view-list-symbolic'],
      ['vbox4', 'هفته', 'x-office-calendar-symbolic'],
      ['vbox5', 'اوقات شرعی', 'audio-speakers-symbolic'],
      ['vbox6', 'بازنشانی', 'view-refresh-symbolic'],
      ['vbox7', 'درباره', 'help-about-symbolic'],
    ].forEach((v) => {
      this['page' + v[0]] = new Adw.PreferencesPage({
        title: v[1],
        icon_name: v[2],
      });
      window.add(this['page' + v[0]]);

      this['group' + v[0]] = new Adw.PreferencesGroup({
        //title: 'تنظیمات ' + v[1],
        //description: 'ــــــــ',
      });
      this['page' + v[0]].add(this['group' + v[0]]);

      this[v[0]] = new Gtk.Box({ orientation: Gtk.Orientation.VERTICAL, spacing: 6, halign: Gtk.Align.CENTER, margin_top: 14, margin_bottom: 14, margin_start: 14, margin_end: 14 });
      this['group' + v[0]].add(this[v[0]]);
    });










    // Top bar Panel
    this.vbox1.append(new Gtk.Label({ label: 'تنظیم متن نمایشی ابزارک تاریخ در تابلوی نوار اصلی گنوم:\n' }));

    this.el['widget-position'] = new Gtk.ComboBoxText();
    this.el['widget-position'].append('left', 'سمت چپ');
    this.el['widget-position'].append('center', 'وسط نوار');
    this.el['widget-position'].append('right', 'سمت راست');
    this.el['widget-position'].set_active(this.schema.get_string('widget-position'));
    this.schema.bind('widget-position', this.el['widget-position'], 'active-id', Gio.SettingsBindFlags.DEFAULT);


    this.el['custom-color'] = new Gtk.CheckButton({ label: 'رنگ سفارشی متن' });
    this.schema.bind('custom-color', this.el['custom-color'], 'active', Gio.SettingsBindFlags.DEFAULT);

    let colorsGrid = new Gtk.Box({
      orientation: Gtk.Orientation.HORIZONTAL,
      spacing: 3
    });

    this.el['pray-time-color'] = Gtk.ColorButton.new_with_rgba(this.getColorByHexadecimal(this.schema.get_string('pray-time-color')));
    this.el['pray-time-color'].set_modal(true);
    this.el['pray-time-color'].connect('color-set', (function (innerColor) {
      this.schema.set_string('pray-time-color', this.getHexadecimalByColor(innerColor.get_rgba()));
    }).bind(this));

    this.el['holiday-color'] = Gtk.ColorButton.new_with_rgba(this.getColorByHexadecimal(this.schema.get_string('holiday-color')));
    this.el['holiday-color'].set_modal(true);
    this.el['holiday-color'].connect('color-set', (function (innerColor) {
      this.schema.set_string('holiday-color', this.getHexadecimalByColor(innerColor.get_rgba()));
    }).bind(this));

    this.el['not-holiday-color'] = Gtk.ColorButton.new_with_rgba(this.getColorByHexadecimal(this.schema.get_string('not-holiday-color')));
    this.el['not-holiday-color'].set_modal(true);
    this.el['not-holiday-color'].connect('color-set', (function (innerColor) {
      this.schema.set_string('not-holiday-color', this.getHexadecimalByColor(innerColor.get_rgba()));
    }).bind(this));

    colorsGrid.append(this.el['pray-time-color']);
    colorsGrid.append(new Gtk.Label({ label: ' هنگام اوقات شرعی:' }));
    colorsGrid.append(this.el['holiday-color']);
    colorsGrid.append(new Gtk.Label({ label: ' روز تعطیل:' }));
    colorsGrid.append(this.el['not-holiday-color']);
    colorsGrid.append(new Gtk.Label({ label: ' روز عادی:' }));

    sensitiveFunc = () => {
      let els = ['pray-time-color', 'not-holiday-color', 'holiday-color'];
      let active = this.schema.get_boolean('custom-color');
      els.forEach((el) => this.el[el].set_sensitive(active));
    }
    sensitiveFunc();
    this.schema.connect('changed::custom-color', sensitiveFunc);



    this.el['widget-format'] = new Gtk.ComboBoxText();
    for (let showFormat of showFormats) this.el['widget-format'].append(
      showFormat,
      Str.numbersFormat(
        Str.dateStrFormat(
          showFormat,
          _dateObj.persianDay,
          _dateObj.persianMonth,
          _dateObj.persianYear,
          _dateObj.dayOfWeek,
          'persian'
        )
      )
    );
    this.el['widget-format'].set_active(this.schema.get_string('widget-format'));
    this.schema.bind('widget-format', this.el['widget-format'], 'active-id', Gio.SettingsBindFlags.DEFAULT);

    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 6 });
    hbox.append(this.el['widget-format']);
    hbox.append(new Gtk.Label({ label: '      قالب: ' }));
    hbox.append(this.el['widget-position']);
    hbox.append(new Gtk.Label({ label: 'موقعیت ابزارک تاریخ: ' }));
    this.vbox1.append(hbox);

    this.vbox1.append(new Gtk.Label({ label: '' }));

    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 6 });
    hbox.append(colorsGrid);
    hbox.append(this.el['custom-color']);
    this.vbox1.append(hbox);



    this.vbox1.append(new Gtk.Separator({ orientation: Gtk.Orientation.HORIZONTAL, margin_top: 32, margin_bottom: 8 }));


    this.el['startup-notification'] = new Gtk.CheckButton({ label: 'همیشه یک اعلان متنی هنگام راه‌اندازی (هنگام ورود به میزکار یا بازنشانی افزونه)' });
    this.vbox1.append(this.el['startup-notification']);
    this.schema.bind('startup-notification', this.el['startup-notification'], 'active', Gio.SettingsBindFlags.DEFAULT);


    // FONT
    /* item = new Gtk.CheckButton({label: 'Use custom font'})
    this.vbox1.append(item)
    this.schema.bind('custom-font', item, 'active', Gio.SettingsBindFlags.DEFAULT);
   
    label = new Gtk.Label({label: "Font: "});
    let font = new Gtk.FontButton();
    font.set_show_size(false);
    font.set_show_style(false);
   
    let _actor = new Gtk.Box({orientation: Gtk.Orientation.HORIZONTAL, spacing: 0});
    _actor.add(label);
    _actor.add(font);
    font.set_font_name(this.schema.get_string(font-name));
   
    this.vbox1.append(_actor);
    font.connect('font-set', function(font){
    this.schema.set_string(font-name, font.get_font_name());
    });*/










    // View Window, Dates format
    this.vbox2.append(new Gtk.Label({ label: 'قالب پنجره تقویم:\n' }));

    let themes = {
      0: "خاکستری",
      1: "سفید"
    };
    this.el['dark-theme-id'] = new Gtk.ComboBoxText();
    this.el['light-theme-id'] = new Gtk.ComboBoxText();
    for (let i in themes) {
      this.el['dark-theme-id'].append(i, themes[i]);
      this.el['light-theme-id'].append(i, themes[i]);
    }
    this.el['dark-theme-id'].set_active(this.schema.get_int('dark-theme-id'));
    this.el['light-theme-id'].set_active(this.schema.get_int('light-theme-id'));
    this.schema.bind('dark-theme-id', this.el['dark-theme-id'], 'active', Gio.SettingsBindFlags.DEFAULT);
    this.schema.bind('light-theme-id', this.el['light-theme-id'], 'active', Gio.SettingsBindFlags.DEFAULT);
    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 0 });
    hbox.append(this.el['dark-theme-id']);
    hbox.append(new Gtk.Label({ label: '        در حالت تاریک: ' }));
    hbox.append(this.el['light-theme-id']);
    hbox.append(new Gtk.Label({ label: 'در حالت روشن: ' }));

    this.vbox2.append(hbox);


    this.vbox2.append(new Gtk.Separator({ orientation: Gtk.Orientation.HORIZONTAL, margin_top: 8, margin_bottom: 8 }));


    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 0 });

    let tabs = {
      dateConvert: "تبدیل تاریخ",
      prayTimes: "اوقات شرعی",
      events: "مناسبت‌ها"
    };
    this.el['default-tab'] = new Gtk.ComboBoxText();
    for (let i in tabs) this.el['default-tab'].append(i, tabs[i]);
    this.el['default-tab'].set_active(this.schema.get_string('default-tab'));
    this.schema.bind('default-tab', this.el['default-tab'], 'active-id', Gio.SettingsBindFlags.DEFAULT);
    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 0 });
    hbox.append(new Gtk.Label({ label: '' }));
    hbox.append(this.el['default-tab']);
    hbox.append(new Gtk.Label({ label: '     زبانه‌ی فعّال پیشفرض: ' }));

    this.el['window-position'] = new Gtk.ComboBoxText();
    this.el['window-position'].append('left', 'سمت چپ');
    this.el['window-position'].append('center', 'وسط');
    this.el['window-position'].append('right', 'سمت راست');
    this.el['window-position'].set_active(this.schema.get_string('window-position'));
    this.schema.bind('window-position', this.el['window-position'], 'active-id', Gio.SettingsBindFlags.DEFAULT);
    hbox.append(new Gtk.Label({ label: '' }));
    hbox.append(this.el['window-position']);
    hbox.append(new Gtk.Label({ label: 'مکان پنجره: ' }));

    this.vbox2.append(hbox);


    this.vbox2.append(new Gtk.Separator({ orientation: Gtk.Orientation.HORIZONTAL, margin_top: 8, margin_bottom: 8 }));


    this.vbox2.append(new Gtk.Label({ label: 'فعال بودن و نمایش تاریخ‌ها:\n' }));

    this.el['persian-display'] = new Gtk.CheckButton({ label: 'هجری شمسی' });
    this.schema.bind('persian-display', this.el['persian-display'], 'active', Gio.SettingsBindFlags.DEFAULT);
    this.el['persian-display-format'] = new Gtk.ComboBoxText();
    for (let showFormat of showFormats) this.el['persian-display-format'].append(
      showFormat,
      Str.numbersFormat(
        Str.dateStrFormat(
          showFormat,
          _dateObj.persianDay,
          _dateObj.persianMonth,
          _dateObj.persianYear,
          _dateObj.dayOfWeek,
          'persian'
        )
      )
    );
    this.el['persian-display-format'].set_active(this.schema.get_string('persian-display-format'));
    this.schema.bind('persian-display-format', this.el['persian-display-format'], 'active-id', Gio.SettingsBindFlags.DEFAULT);
    sensitiveFunc = () => {
      this.el['persian-display-format'].set_sensitive(this.schema.get_boolean('persian-display'));
    }
    sensitiveFunc();
    this.schema.connect('changed::persian-display', sensitiveFunc);
    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 0 });
    hbox.append(new Gtk.Label({ label: '' }));
    hbox.append(this.el['persian-display-format']);
    hbox.append(new Gtk.Label({ label: '   قالب: ' }));
    hbox.append(this.el['persian-display']);
    this.vbox2.append(hbox);


    this.vbox2.append(new Gtk.Label({ label: '' }));


    this.el['islamic-display'] = new Gtk.CheckButton({ label: 'هجری قمری' });
    this.schema.bind('islamic-display', this.el['islamic-display'], 'active', Gio.SettingsBindFlags.DEFAULT);
    this.el['islamic-display-format'] = new Gtk.ComboBoxText();
    for (let showFormat of showFormats) this.el['islamic-display-format'].append(
      showFormat,
      Str.numbersFormat(
        Str.dateStrFormat(
          showFormat,
          _dateObj.islamicDay,
          _dateObj.islamicMonth,
          _dateObj.islamicYear,
          _dateObj.dayOfWeek,
          'islamic'
        )
      )
    );
    this.el['islamic-display-format'].set_active(this.schema.get_string('islamic-display-format'));
    this.schema.bind('islamic-display-format', this.el['islamic-display-format'], 'active-id', Gio.SettingsBindFlags.DEFAULT);
    sensitiveFunc = () => {
      this.el['islamic-display-format'].set_sensitive(this.schema.get_boolean('islamic-display'));
    }
    sensitiveFunc();
    this.schema.connect('changed::islamic-display', sensitiveFunc);
    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 0 });
    hbox.append(new Gtk.Label({ label: '' }));
    hbox.append(this.el['islamic-display-format']);
    hbox.append(new Gtk.Label({ label: '   قالب: ' }));
    hbox.append(this.el['islamic-display']);
    this.vbox2.append(hbox);


    this.vbox2.append(new Gtk.Label({ label: '' }));


    this.el['gregorian-display'] = new Gtk.CheckButton({ label: 'میلادی' });
    this.schema.bind('gregorian-display', this.el['gregorian-display'], 'active', Gio.SettingsBindFlags.DEFAULT);
    this.el['gregorian-display-format'] = new Gtk.ComboBoxText();
    for (let showFormat of showFormats) this.el['gregorian-display-format'].append(
      showFormat,
      // Str.numbersFormat(
      Str.dateStrFormat(
        showFormat,
        _dateObj.gregorianDay,
        _dateObj.gregorianMonth,
        _dateObj.gregorianYear,
        _dateObj.dayOfWeek,
        'gregorian'
      )
      // )
    );
    this.el['gregorian-display-format'].set_active(this.schema.get_string('gregorian-display-format'));
    this.schema.bind('gregorian-display-format', this.el['gregorian-display-format'], 'active-id', Gio.SettingsBindFlags.DEFAULT);
    sensitiveFunc = () => {
      this.el['gregorian-display-format'].set_sensitive(this.schema.get_boolean('gregorian-display'));
    }
    sensitiveFunc();
    this.schema.connect('changed::gregorian-display', sensitiveFunc);
    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 0 });
    hbox.append(new Gtk.Label({ label: '' }));
    hbox.append(this.el['gregorian-display-format']);
    hbox.append(new Gtk.Label({ label: '   قالب: ' }));
    hbox.append(this.el['gregorian-display']);
    this.vbox2.append(hbox);










    // EVENTS
    this.vbox3.append(new Gtk.Label({
      label: 'تنظیمات نمایش مناسبت‌ها:\n<span size="x-small">(مناسبت‌های رسمی و غیر رسمی قابل نمایش)</span>',
      use_markup: true
    }));

    this.vbox3.append(new Gtk.Separator({ orientation: Gtk.Orientation.HORIZONTAL, margin_top: 8, margin_bottom: 8 }));

    this.el['show-persian-events'] = new Gtk.CheckButton({ label: 'مناسبت‌های رسمی کشور: هجری‌شمسی' });
    this.vbox3.append(this.el['show-persian-events']);
    this.schema.bind('show-persian-events', this.el['show-persian-events'], 'active', Gio.SettingsBindFlags.DEFAULT);

    this.el['show-islamic-events'] = new Gtk.CheckButton({ label: 'مناسبت‌های رسمی کشور: هجری‌قمری' });
    this.vbox3.append(this.el['show-islamic-events']);
    this.schema.bind('show-islamic-events', this.el['show-islamic-events'], 'active', Gio.SettingsBindFlags.DEFAULT);

    this.el['show-gregorian-events'] = new Gtk.CheckButton({ label: 'مناسبت‌های رسمی کشور: میلادی (جهانی)' });
    this.vbox3.append(this.el['show-gregorian-events']);
    this.schema.bind('show-gregorian-events', this.el['show-gregorian-events'], 'active', Gio.SettingsBindFlags.DEFAULT);

    this.el['show-old-events'] = new Gtk.CheckButton({ label: 'مناسبت‌های غیر رسمی در ایران باستان' });
    this.vbox3.append(this.el['show-old-events']);
    this.schema.bind('show-old-events', this.el['show-old-events'], 'active', Gio.SettingsBindFlags.DEFAULT);








    // WEEK
    this.vbox4.append(new Gtk.Label({ label: 'تنظیمات روزهای هفته\n\n' }));

    this.el['week-start'] = new Gtk.ComboBoxText();
    this.el['week-start'].append('0', 'شنبه');
    this.el['week-start'].append('1', 'یک‌شنبه');
    this.el['week-start'].append('2', 'دوشنبه');
    this.el['week-start'].append('3', 'سه‌شنبه');
    this.el['week-start'].append('4', 'چهارشنبه');
    this.el['week-start'].append('5', 'پنج‌شنبه');
    this.el['week-start'].append('6', 'جمعه');
    this.el['week-start'].set_active(this.schema.get_string('week-start'));
    this.schema.bind('week-start', this.el['week-start'], 'active-id', Gio.SettingsBindFlags.DEFAULT);
    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 0 });
    hbox.append(new Gtk.Label({ label: '' }));
    hbox.append(new Gtk.Label({ label: '' }));
    hbox.append(this.el['week-start']);
    hbox.append(new Gtk.Label({ label: 'آغاز هفته: ' }));
    this.vbox4.append(hbox);


    this.vbox4.append(new Gtk.Separator({ orientation: Gtk.Orientation.HORIZONTAL, margin_top: 8, margin_bottom: 8 }));


    this.vbox4.append(new Gtk.Label({
      label: 'روزهای تعطیل در هفته:',
      use_markup: true
    }));

    this.el['none-work-0'] = new Gtk.CheckButton({ label: 'شنبه' });
    this.schema.bind('none-work-0', this.el['none-work-0'], 'active', Gio.SettingsBindFlags.DEFAULT);

    this.el['none-work-1'] = new Gtk.CheckButton({ label: 'یک‌شنبه' });
    this.schema.bind('none-work-1', this.el['none-work-1'], 'active', Gio.SettingsBindFlags.DEFAULT);

    this.el['none-work-2'] = new Gtk.CheckButton({ label: 'دوشنبه' });
    this.schema.bind('none-work-2', this.el['none-work-2'], 'active', Gio.SettingsBindFlags.DEFAULT);

    this.el['none-work-3'] = new Gtk.CheckButton({ label: 'سه‌شنبه' });
    this.schema.bind('none-work-3', this.el['none-work-3'], 'active', Gio.SettingsBindFlags.DEFAULT);

    this.el['none-work-4'] = new Gtk.CheckButton({ label: 'چهارشنبه' });
    this.schema.bind('none-work-4', this.el['none-work-4'], 'active', Gio.SettingsBindFlags.DEFAULT);

    this.el['none-work-5'] = new Gtk.CheckButton({ label: 'پنج‌شنبه' });
    this.schema.bind('none-work-5', this.el['none-work-5'], 'active', Gio.SettingsBindFlags.DEFAULT);

    this.el['none-work-6'] = new Gtk.CheckButton({ label: 'جمعه' });
    this.schema.bind('none-work-6', this.el['none-work-6'], 'active', Gio.SettingsBindFlags.DEFAULT);

    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 0 });
    hbox.append(new Gtk.Label({ label: '' }));
    hbox.append(this.el['none-work-6']);
    hbox.append(this.el['none-work-5']);
    hbox.append(this.el['none-work-4']);
    hbox.append(this.el['none-work-3']);
    hbox.append(this.el['none-work-2']);
    hbox.append(this.el['none-work-1']);
    hbox.append(this.el['none-work-0']);
    hbox.append(new Gtk.Label({ label: '' }));
    this.vbox4.append(hbox);


    this.vbox4.append(new Gtk.Separator({ orientation: Gtk.Orientation.HORIZONTAL, margin_top: 8, margin_bottom: 8 }));


    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 0 });
    this.el['reverse-direction'] = new Gtk.CheckButton({ label: 'ترتیب چیدمان برعکس' });
    this.schema.bind('reverse-direction', this.el['reverse-direction'], 'active', Gio.SettingsBindFlags.DEFAULT);
    hbox.append(this.el['reverse-direction']);
    this.vbox4.append(hbox);

    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 0 });
    this.el['rotaton-to-vertical'] = new Gtk.CheckButton({ label: 'عمودی‌شدن جدول تقویم' });
    this.schema.bind('rotaton-to-vertical', this.el['rotaton-to-vertical'], 'active', Gio.SettingsBindFlags.DEFAULT);
    hbox.append(this.el['rotaton-to-vertical']);
    this.vbox4.append(hbox);










    //PrayTimes
    this.vbox5.append(new Gtk.Label({ label: 'تذکّر: حتماً نتایج نرم‌افزار را با اذان محلّی شهرتان مطابقت دهید و همیشه جوانب احتیاط را رعایت فرمایید!' }));


    this.vbox5.append(new Gtk.Separator({ orientation: Gtk.Orientation.HORIZONTAL, margin_top: 8, margin_bottom: 8 }));


    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 3, margin_top: 6 });
    hbox.border_width = 3;

    const soundsUri = /* '.local/share/gnome-shell/extensions/' + uuid */ path + '/' + sound.soundsDir + '/';
    const sounds = {
      ...sound.sounds,
      "_custom_": [
        'انتخاب فایل سفارشی ←',
        '_custom_'
      ],
    };


    const ptCalcMethods = {
      Tehran: "انجمن ژئوفیزیک، دانشگاه تهران ☫",
      Jafari: "انجمن لواء، قم",
      MWL: "اتّحادیه‌ی جهانی اسلام، عربستان سعودی",
      ISNA: "جامعه‌ی اسلامی آمریکای شمالی",
      Egypt: "مرجع عمومی تحقیقات مصر",
      Makkah: "دانشگاه امّ‌القریٰ، مکّه",
      Karachi: "دانشگاه علوم اسلامی، کراچی"
    };

    // MainCalcMethod:
    this.el['praytime-calc-method-main'] = new Gtk.ComboBoxText();
    for (let i in ptCalcMethods) {
      this.el['praytime-calc-method-main'].append(i, ptCalcMethods[i]);
    }
    this.el['praytime-calc-method-main'].set_active_id(this.schema.get_string('praytime-calc-method-main'));
    this.el['praytime-calc-method-main'].connect('changed', () => {
      this.schema.set_string('praytime-calc-method-main', this.el['praytime-calc-method-main'].get_active_id().toString());
    });

    // EhtyiatCalcMethod:
    this.el['praytime-calc-method-ehtiyat'] = new Gtk.ComboBoxText();
    for (let i in ptCalcMethods) {
      this.el['praytime-calc-method-ehtiyat'].append(i, ptCalcMethods[i]);
    }
    this.el['praytime-calc-method-ehtiyat'].set_active_id(this.schema.get_string('praytime-calc-method-ehtiyat'));
    this.el['praytime-calc-method-ehtiyat'].connect('changed', () => {
      this.schema.set_string('praytime-calc-method-ehtiyat', this.el['praytime-calc-method-ehtiyat'].get_active_id().toString());
    });

    this.el['praytime-ehtiyat-show'] = new Gtk.CheckButton({ label: 'نمایش احتیاط' });
    this.schema.bind('praytime-ehtiyat-show', this.el['praytime-ehtiyat-show'], 'active', Gio.SettingsBindFlags.DEFAULT);

    hbox.append(this.el['praytime-calc-method-main']);
    hbox.append(new Gtk.Label({ label: '      روش محاسبه‌ی اصلی: ' }));

    let prayTimeSetting = new Gtk.Button({ label: 'تنظیمات پیشرفته' });
    prayTimeSetting.connect('clicked', () => {

      let dialog = new Gtk.Dialog({
        title: 'تنظیمات پیشرفته‌ی اوقات شرعی',
        transient_for: this.vbox5.get_root(),
        use_header_bar: true,
        modal: true,
        default_width: 50
      });

      dialog.add_button('بازنشانی تنظیمات این بخش', 1);



      let gridAzanAdvanceSettings = new Gtk.Grid({
        row_spacing: 4,
        column_spacing: 1,
        margin_top: 14,
        margin_bottom: 14,
        margin_start: 14,
        margin_end: 14
      });

      [
        '(*.ogg) فایل',
        'صدای اذان',
        'طبق روش',
        'پخش صدا',
        'اعلان متنی',
        'نمایش',
        '↴ وقت'
      ].forEach((title, col) => {
        gridAzanAdvanceSettings.attach(new Gtk.Label({ use_markup: true, label: '<span foreground="#05c" weight="bold">' + title + '</span>' }), col, 0, 1, 1);
      });


      let row = 0;
      for (let tName in this.NewPrayTimes.persianMap) {
        row++;
        const title = this.NewPrayTimes.persianMap[tName];
        const {
          ShowTime,
          TextNotify,
          PlaySound,
          CalcMethod,
          SoundId
        } = getPrayTimeSetting(tName, this.schema);
        const SoundUri = this.schema.get_string('praytime-' + tName + '-sound-uri');

        // SoundUri
        this.el['praytime-' + tName + '-sound-uri'] = new Gtk.Button({ label: '  →  غیرفعال  ', sensitive: (SoundId === '_custom_'), margin_bottom: 0/**/ });

        this.el['praytime-' + tName + '-sound-uri'].connect('clicked', () => {
          let fChNative = new Gtk.FileChooserNative({
            title: 'انتخاب یک فایل صوتی',
            transient_for: this.el['praytime-' + tName + '-sound-uri'].get_root(),
            modal: true,
            action: Gtk.FileChooserAction.OPEN,
            select_multiple: false
          });
          {
            let audioFilter = new Gtk.FileFilter;
            audioFilter.add_mime_type('audio/ogg');// 'audio/*' 'audio/mpeg'
            fChNative.set_filter(audioFilter);
          }
          fChNative.connect('response', (native, response) => {
            if (response !== Gtk.ResponseType.ACCEPT) {
              return;
            }
            let fileURI = native.get_file().get_path();
            this.schema.set_string('praytime-' + tName + '-sound-uri', fileURI);
            fileURI = fileURI.slice(0, fileURI.lastIndexOf('.'));
            fileURI = fileURI.slice(fileURI.lastIndexOf('/') + 1);
            if (fileURI.length > 8) fileURI = fileURI.slice(0, 8) + '...';
            this.btnIconLabel(this.el['praytime-' + tName + '-sound-uri'], fileURI);
          });
          fChNative.show();
        });

        // SoundId
        let fileName = '';
        this.el['praytime-' + tName + '-setting_SoundId'] = new Gtk.ComboBoxText({ margin_bottom: 2 });
        for (let i in sounds) {
          this.el['praytime-' + tName + '-setting_SoundId'].append(i, sounds[i][0]);
        }
        this.el['praytime-' + tName + '-setting_SoundId'].set_active_id(SoundId);
        this.el['praytime-' + tName + '-setting_SoundId'].connect('changed', () => {
          let newSoundId = this.el['praytime-' + tName + '-setting_SoundId'].get_active_id().toString();
          this.setPrayTimeSetting(tName, 'SoundId', newSoundId);
          //this.el['praytime-' + tName + '-sound-uri'].set_sensitive(newSoundId === '_custom_');

          if (newSoundId === '_custom_') {
            //selectedSoundUri = '';
            this.el['praytime-' + tName + '-sound-uri'].set_sensitive(true);
            if (SoundUri === '' || SoundUri === 'Music') {
              this.btnIconLabel(this.el['praytime-' + tName + '-sound-uri'], '');
            } else {
              fileName = SoundUri.slice(0, SoundUri.lastIndexOf('.'));
              fileName = fileName.slice(fileName.lastIndexOf('/') + 1);
              if (fileName.length > 8) fileName = fileName.slice(0, 8) + '...';
              this.btnIconLabel(this.el['praytime-' + tName + '-sound-uri'], fileName);
            }
          } else {
            //selectedSoundUri = soundsUri + sounds[newSoundId][1];
            this.el['praytime-' + tName + '-sound-uri'].set_sensitive(false);
            this.el['praytime-' + tName + '-sound-uri'].set_label('  →  غیرفعال  ');
          }
        });

        if (this.el['praytime-' + tName + '-setting_SoundId'].get_active_id().toString() === '_custom_') {
          if (SoundUri === '' || SoundUri === 'Music') {
            this.btnIconLabel(this.el['praytime-' + tName + '-sound-uri'], '');
          } else {
            fileName = SoundUri.slice(0, SoundUri.lastIndexOf('.'));
            fileName = fileName.slice(fileName.lastIndexOf('/') + 1);
            if (fileName.length > 8) fileName = fileName.slice(0, 8) + '...';
            this.btnIconLabel(this.el['praytime-' + tName + '-sound-uri'], fileName);
          }
        } else {
          this.el['praytime-' + tName + '-sound-uri'].set_label('  →  غیرفعال  ');
        }

        // CalcMethod
        let list = {
          main: "اصلی",
          ehtiyat: "احتیاط"
        };
        this.el['praytime-' + tName + '-setting_CalcMethod'] = new Gtk.ComboBoxText({ margin_bottom: 2 });
        for (let i in list) {
          this.el['praytime-' + tName + '-setting_CalcMethod'].append(i, list[i]);
        }
        this.el['praytime-' + tName + '-setting_CalcMethod'].set_active_id(CalcMethod);
        this.el['praytime-' + tName + '-setting_CalcMethod'].connect('changed', () => {
          this.setPrayTimeSetting(tName, 'CalcMethod', this.el['praytime-' + tName + '-setting_CalcMethod'].get_active_id());
        });

        // PlaySound & TextNotify & ShowTime
        list = {
          always: "همیشه",
          ramazan: "رمضان",
          never: "هیچگاه"
        };

        //PlaySound
        this.el['praytime-' + tName + '-setting_PlaySound'] = new Gtk.ComboBoxText({ margin_bottom: 2 });
        for (let i in list) {
          this.el['praytime-' + tName + '-setting_PlaySound'].append(i, list[i]);
        }
        this.el['praytime-' + tName + '-setting_PlaySound'].set_active_id(PlaySound);
        sensitiveFunc = (playSound, tName_) => {
          let active = (playSound !== 'never');
          let els = ['praytime-' + tName_ + '-setting_SoundId', 'praytime-' + tName_ + '-setting_CalcMethod'];
          els.forEach((el) => this.el[el].set_sensitive(active));
          //
          let newSoundId = this.el['praytime-' + tName_ + '-setting_SoundId'].get_active_id().toString();
          this.el['praytime-' + tName_ + '-sound-uri'].set_sensitive(active && newSoundId === '_custom_');
        }
        sensitiveFunc(PlaySound, tName);
        this.el['praytime-' + tName + '-setting_PlaySound'].connect('changed', () => {
          let playSound = this.el['praytime-' + tName + '-setting_PlaySound'].get_active_id();
          this.setPrayTimeSetting(tName, 'PlaySound', playSound);
          sensitiveFunc(playSound, tName);
        });

        //TextNotify
        this.el['praytime-' + tName + '-setting_TextNotify'] = new Gtk.ComboBoxText({
          margin_bottom: 2,
          margin_start: 4,
          margin_end: 4
        });
        for (let i in list) {
          this.el['praytime-' + tName + '-setting_TextNotify'].append(i, list[i]);
        }
        this.el['praytime-' + tName + '-setting_TextNotify'].set_active_id(TextNotify);
        this.el['praytime-' + tName + '-setting_TextNotify'].connect('changed', () => {
          this.setPrayTimeSetting(tName, 'TextNotify', this.el['praytime-' + tName + '-setting_TextNotify'].get_active_id());
        });

        //ShowTime
        this.el['praytime-' + tName + '-setting_ShowTime'] = new Gtk.ComboBoxText({ margin_bottom: 2 });
        for (let i in list) {
          this.el['praytime-' + tName + '-setting_ShowTime'].append(i, list[i]);
        }
        this.el['praytime-' + tName + '-setting_ShowTime'].set_active_id(ShowTime);
        this.el['praytime-' + tName + '-setting_ShowTime'].connect('changed', () => {
          this.setPrayTimeSetting(tName, 'ShowTime', this.el['praytime-' + tName + '-setting_ShowTime'].get_active_id());
        });

        // Label
        let label = new Gtk.Label({ use_markup: true, label: '<span foreground="#080" weight="bold">' + title + ': ' + '</span>' })



        gridAzanAdvanceSettings.attach(this.el['praytime-' + tName + '-sound-uri'], 0, row, 1, 1);
        gridAzanAdvanceSettings.attach(this.el['praytime-' + tName + '-setting_SoundId'], 1, row, 1, 1);
        gridAzanAdvanceSettings.attach(this.el['praytime-' + tName + '-setting_CalcMethod'], 2, row, 1, 1);
        gridAzanAdvanceSettings.attach(this.el['praytime-' + tName + '-setting_PlaySound'], 3, row, 1, 1);
        gridAzanAdvanceSettings.attach(this.el['praytime-' + tName + '-setting_TextNotify'], 4, row, 1, 1);
        gridAzanAdvanceSettings.attach(this.el['praytime-' + tName + '-setting_ShowTime'], 5, row, 1, 1);
        gridAzanAdvanceSettings.attach(label, 6, row, 1, 1);

      }

      dialog.get_content_area().append(gridAzanAdvanceSettings);

      dialog.connect('response', (dialog, id) => {
        if (id == 1) {
          this._resetPrayTimesAdvanceSettings();
        } else {
          //dialog.get_content_area().remove(gridAzanAdvanceSettings);
          //dialog.destroy();
        }
        return;
      });

      dialog.present();
    });
    hbox.append(prayTimeSetting);

    this.vbox5.append(hbox);



    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 3 });
    hbox.border_width = 3;
    hbox.append(this.el['praytime-calc-method-ehtiyat']);
    hbox.append(new Gtk.Label({ label: 'احتیاط بین روش اصلی و روش: ' }));
    hbox.append(this.el['praytime-ehtiyat-show']);
    this.vbox5.append(hbox);


    this.vbox5.append(new Gtk.Separator({ orientation: Gtk.Orientation.HORIZONTAL, margin_top: 8, margin_bottom: 8 }));


    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 3 });
    hbox.border_width = 3;
    this.el['praytime-city'] = new Gtk.Entry({ max_length: 22, width_chars: 22 });

    this.el['praytime-lat'] = new Gtk.Entry({ max_length: 7, width_chars: 7 });
    hbox.append(this.el['praytime-lat']);
    hbox.append(new Gtk.Label({ label: '    عرض جغرافیایی: ' }));
    this.el['praytime-lat'].set_text(this.schema.get_double('praytime-lat').toString());
    this.el['praytime-lat'].connect('changed', () => {
      if (isNaN(parseFloat(this.el['praytime-lat'].text))) return false;
      this.schema.set_double('praytime-lat', parseFloat(this.el['praytime-lat'].text));
      this.el['praytime-city'].set_text('_سفارشی_');
      this.schema.set_string('praytime-city', '_سفارشی_');
    });

    this.el['praytime-lng'] = new Gtk.Entry({ max_length: 7, width_chars: 7 });
    hbox.append(this.el['praytime-lng']);
    hbox.append(new Gtk.Label({ label: '      طول جغرافیایی: ' }));
    this.el['praytime-lng'].set_text(this.schema.get_double('praytime-lng').toString());
    this.el['praytime-lng'].connect('changed', () => {
      if (isNaN(parseFloat(this.el['praytime-lng'].text))) return false;
      this.schema.set_double('praytime-lng', parseFloat(this.el['praytime-lng'].text));
      this.el['praytime-city'].set_text('_سفارشی_');
      this.schema.set_string('praytime-city', '_سفارشی_');
    });




    const chaneLocation = (cityData) => {
      this.el['praytime-lat'].set_text(cityData[1].toString());
      this.schema.set_double('praytime-lat', cityData[1]);

      this.el['praytime-lng'].set_text(cityData[2].toString());
      this.schema.set_double('praytime-lng', cityData[2]);

      this.el['praytime-city'].set_text(cityData[0]);
      this.schema.set_string('praytime-city', cityData[0]);
    }



    let selectCity = new Gtk.Button({ label: 'انتخاب شهر از فهرست' });
    selectCity.connect('clicked', () => {
      let _stateId = this.schema.get_int('praytime-state');
      let _cityData = [this.schema.get_string('praytime-city'), 0, 0];

      let dialog = new Gtk.Dialog({
        title: 'انتخاب شهر از فهرست',
        transient_for: this.vbox5.get_root(),
        use_header_bar: true,
        modal: true,
        default_width: 50
      });

      dialog.add_button('بازنشانی', 1);//Reset Button

      this.el['praytime-state'] = new Gtk.ComboBoxText();
      this.el['praytime-city_ComboBox'] = new Gtk.ComboBoxText();

      let stateAndCitySubmit = new Gtk.Button({ label: '\nذخیره\n', margin_top: 14 });

      for (let i in Cities.cities) {
        this.el['praytime-state'].append(
          i,
          Str.numbersFormat(
            Str.dateStrFormat(
              Cities.cities[i][0],
              _dateObj.persianDay,
              _dateObj.persianMonth,
              _dateObj.persianYear,
              _dateObj.dayOfWeek,
              'persian'
            )
          )
        );
      }
      if (Cities.cities[_stateId] !== undefined) this.el['praytime-state'].set_active(_stateId);

      const changeStateAndCity = (stateId, cityName = null) => {
        this.el['praytime-city_ComboBox'].remove_all();
        let cityId = -1;
        let centerId = 0;
        let cities = Cities.cities[stateId];
        for (let i in cities) {
          if (i == 0) continue;
          if (cityName !== null && cityName === cities[i][0]) cityId = i - 1;
          if (cities[i][3] !== undefined) centerId = i - 1;
          this.el['praytime-city_ComboBox'].append(
            cities[i][0],
            Str.numbersFormat(
              Str.dateStrFormat(
                cities[i][0],
                _dateObj.persianDay,
                _dateObj.persianMonth,
                _dateObj.persianYear,
                _dateObj.dayOfWeek,
                'persian'
              )
            )
          );
        }

        if (cityId === -1) cityId = centerId;
        this.el['praytime-city_ComboBox'].set_active(cityId);
        _cityData = Cities.cities[stateId][cityId + 1];
      }

      this.el['praytime-city_ComboBox'].connect('changed', () => {
        _cityData = Cities.cities[_stateId][this.el['praytime-city_ComboBox'].get_active() + 1];
        stateAndCitySubmit.label = "ذخیره";
        stateAndCitySubmit.set_sensitive(true);
      });

      changeStateAndCity(_stateId, _cityData[0]);
      this.el['praytime-state'].connect('changed', () => {
        _stateId = this.el['praytime-state'].get_active();
        changeStateAndCity(_stateId, _cityData[0]);
        stateAndCitySubmit.label = "ذخیره";
        stateAndCitySubmit.set_sensitive(true);
      });



      let box = new Gtk.Box({
        orientation: Gtk.Orientation.VERTICAL, spacing: 10, halign: Gtk.Align.CENTER, margin_top: 14, margin_bottom: 14, margin_start: 14, margin_end: 14
      });

      let boxH = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL });
      boxH.append(this.el['praytime-city_ComboBox']);
      boxH.append(new Gtk.Label({ label: '      شهر: ' }));
      boxH.append(this.el['praytime-state']);
      boxH.append(new Gtk.Label({ label: 'استان: ' }));
      box.append(boxH);

      box.append(stateAndCitySubmit);

      box.append(new Gtk.Label({
        label: '<span size="small">\nاگر مکان شما در فهرست بالا نیست و یا مختصات آن اشتباه است،\nمی‌توانید در صفحه‌ی اصلی، اطّلاعات را به‌صورت دستی وارد نمایید.</span>',
        use_markup: true
      }));

      dialog.get_content_area().append(box);

      stateAndCitySubmit.connect('clicked', () => {
        chaneLocation(_cityData);
        this.schema.set_int('praytime-state', _stateId);
        // this.el['praytime-timezone'].set_active(18);//index 18: Asia/Tehran
        // this.schema.set_double('praytime-timezone', 3.5);//TZ 3.5: Asia/Tehran
        stateAndCitySubmit.label = _cityData[0] + " :: مختصات جغرافیایی = [عرض:" + _cityData[1] + " , طول:" + _cityData[2] + "]";
        stateAndCitySubmit.set_sensitive(false);
      });

      dialog.connect('response', (dialog, id) => {
        if (id == 1) {
          changeStateAndCity(7);// 7: Tehran State
          this.el['praytime-state'].set_active(7);// 7: Tehran State
          // this.el['praytime-timezone'].set_active(18);//index 18: Asia/Tehran
          // this.schema.set_double('praytime-timezone', 3.5);//TZ 3.5: Asia/Tehran
        } else {
          // remove the settings box so it doesn't get destroyed;
          // this.el['praytime-state'].set_active(7);// 7: Tehran State
          // this.schema.bind('praytime-state', this.el['praytime-state'], 'active-id', Gio.SettingsBindFlags.DEFAULT);
          //dialog.get_content_area().remove(box);
          //dialog.destroy();
        }
        return;
      });

      dialog.present();
    });

    hbox.append(selectCity);
    this.vbox5.append(hbox);

    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 3 });
    hbox.border_width = 3;

    // let tzs = [
    //   [-12, 'UTC−12:00'],
    //   [-11, 'UTC−11:00'],
    //   [-10, 'UTC−10:00'],
    //   [-9.5, 'UTC−09:30'],
    //   [-9, 'UTC−09:00'],
    //   [-8, 'UTC−08:00'],
    //   [-7, 'UTC−07:00'],
    //   [-6, 'UTC−06:00'],
    //   [-5, 'UTC−05:00'],
    //   [-4, 'UTC−04:00'],
    //   [-3.5, 'UTC−03:30'],
    //   [-3, 'UTC−03:00'],
    //   [-2, 'UTC−02:00'],
    //   [-1, 'UTC−01:00'],
    //   [0, 'UTC±00:00'],
    //   [1, 'UTC+01:00'],
    //   [2, 'UTC+02:00'],
    //   [3, 'UTC+03:00'],
    //   [3.5, 'UTC+03:30'],
    //   [4, 'UTC+04:00'],
    //   [4.5, 'UTC+04:30'],
    //   [5, 'UTC+05:00'],
    //   [5.5, 'UTC+05:30'],
    //   [5.75, 'UTC+05:45'],
    //   [6, 'UTC+06:00'],
    //   [6.5, 'UTC+06:30'],
    //   [7, 'UTC+07:00'],
    //   [8, 'UTC+08:00'],
    //   [8.75, 'UTC+08:45'],
    //   [9, 'UTC+09:00'],
    //   [9.5, 'UTC+09:30'],
    //   [10, 'UTC+10:00'],
    //   [10.5, 'UTC+10:30'],
    //   [11, 'UTC+11:00'],
    //   [12, 'UTC+12:00'],
    //   [12.75, 'UTC+12:45'],
    //   [13, 'UTC+13:00'],
    //   [14, 'UTC+14:00']
    // ];
    // this.el['praytime-timezone'] = new Gtk.ComboBoxText();
    // let _tz = this.schema.get_double('praytime-timezone');
    // let tzIndex = -1;
    // for (let i in tzs) {
    //   this.el['praytime-timezone'].append(tzs[i][0].toString(), tzs[i][1]);
    //   if (tzs[i][0] === _tz) tzIndex = i;
    // }
    // this.el['praytime-timezone'].set_active(tzIndex);
    // this.el['praytime-timezone'].connect('changed', () => {
    //   this.schema.set_double('praytime-timezone', parseFloat(tzs[this.el['praytime-timezone'].get_active()][0]));
    // });
    // hbox.append(this.el['praytime-timezone']);
    // hbox.append(new Gtk.Label({ label: '      اختلاف ساعت: ' }));

    // let tzEl = new Gtk.Entry({ max_length: 22, width_chars: 22 });
    // tzEl.set_text(this.schema.get_double('praytime-timezone').toString());
    // //this.schema.bind('praytime-timezone', tzEl, 'active', Gio.SettingsBindFlags.DEFAULT);
    // tzEl.connect('changed', () => {
    //   this.schema.set_double('praytime-timezone', parseFloat(tzEl.text));
    // });
    // hbox.append(tzEl);
    // hbox.append(new Gtk.Label({ label: '      اختلاف ساعت: ' }));
    // // let tzEl = this.createTextEntry('praytime-timezone', 'منطقه‌ی زمانی: ');
    // // hbox.append(tzEl.hbox);
    // // if (tzEl.comment) this.vbox5.append(tzEl.comment);



    this.el['praytime-city'].set_text(this.schema.get_string('praytime-city'));
    this.el['praytime-city'].connect('changed', () => {
      this.schema.set_string('praytime-city', this.el['praytime-city'].text);
    });
    hbox.append(this.el['praytime-city']);
    hbox.append(new Gtk.Label({ label: 'نام نمایشی مکان: ' }));


    this.vbox5.append(hbox);


    this.vbox5.append(new Gtk.Separator({ orientation: Gtk.Orientation.HORIZONTAL, margin_top: 8, margin_bottom: 8 }));


    hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 3 });
    hbox.border_width = 3;


    let playSounds = new Gtk.Button({ label: 'آزمایش صداها' });
    playSounds.connect('clicked', () => {


      let dialog = new Gtk.Dialog({
        title: 'آزمایش صداها',
        transient_for: this.vbox1.get_root(),
        use_header_bar: true,
        modal: true,
        default_width: 50
      });


      let selectedSound = '';
      let selectedSoundUri = '';
      let selectedSoundFileName = '';

      let mStream;

      let btnFCh = new Gtk.Button({ label: '  →  غیرفعال  ', sensitive: false });


      btnFCh.connect('clicked', () => {

        this.el['play-sound-file-test'] = new Gtk.FileChooserNative({
          title: 'انتخاب یک فایل صوتی',
          transient_for: btnFCh.get_root(),
          modal: true,
          action: Gtk.FileChooserAction.OPEN,
          select_multiple: false
        });
        {
          let audioFilter = new Gtk.FileFilter;
          audioFilter.add_mime_type('audio/ogg');// 'audio/*' 'audio/mpeg'
          this.el['play-sound-file-test'].set_filter(audioFilter);
        }

        this.el['play-sound-file-test'].connect('response', (native, response) => {
          if (response !== Gtk.ResponseType.ACCEPT) {
            return;
          }
          let fileURI = native.get_file().get_path();
          selectedSoundUri = fileURI;
          fileURI = fileURI.slice(0, fileURI.lastIndexOf('.'));
          fileURI = fileURI.slice(fileURI.lastIndexOf('/') + 1);
          if (fileURI.length > 8) fileURI = fileURI.slice(0, 8) + '...';
          this.btnIconLabel(btnFCh, fileURI);
          selectedSoundFileName = fileURI;
        });
        this.el['play-sound-file-test'].show();
      });



      this.el['play-sound-test'] = new Gtk.ComboBoxText();
      for (let i in sounds) {
        if (selectedSound === '') {
          selectedSound = i;
          selectedSoundUri = soundsUri + sounds[selectedSound][1];
        }
        this.el['play-sound-test'].append(
          i,
          sounds[i][0]
        );
      }
      this.el['play-sound-test'].set_active(selectedSound);
      this.el['play-sound-test'].connect('changed', () => {
        selectedSound = this.el['play-sound-test'].get_active_id();
        if (selectedSound === '_custom_') {
          btnFCh.set_sensitive(true);
          // if (selectedSoundUri === '') {
          this.btnIconLabel(btnFCh, '');
          // } else {
          //   this.btnIconLabel(btnFCh, selectedSoundFileName);
          // }
        } else {
          selectedSoundUri = soundsUri + sounds[selectedSound][1];
          btnFCh.set_sensitive(false);
          btnFCh.set_label('  →  غیرفعال  ');
        }
        if (mStream && mStream.playing) {
          mStream.clear();
          mStream = null;
          if (playPauseBtn && playPauseBtn.label) {
            playPauseBtn.label = 'پخش';
          }
        }
      });

      let box = new Gtk.Box({
        orientation: Gtk.Orientation.VERTICAL, spacing: 10, halign: Gtk.Align.CENTER, margin_top: 14, margin_bottom: 14, margin_start: 14, margin_end: 14
      });

      let boxH = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL });
      boxH.append(btnFCh);
      boxH.append(this.el['play-sound-test']);
      boxH.append(new Gtk.Label({ label: 'عنوان صدا: ' }));
      box.append(boxH);



      /*
      // this option removed!
      let valume = this.schema.get_double('praytime-play-valume');
      let testValume = new Gtk.Scale;
      testValume.set_size_request(293, 14);
      testValume.set_range(0.0, 1.0);
      testValume.set_value(valume);
      const DEFAULT_ICONS_SIZES = [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0];
      for (let i in DEFAULT_ICONS_SIZES) {
        testValume.add_mark(DEFAULT_ICONS_SIZES[i], Gtk.PositionType.TOP, '');
      }
      this._rtl = (Gtk.Widget.get_default_direction() == Gtk.TextDirection.RTL);
      if (this._rtl) {
        testValume.set_value_pos(Gtk.PositionType.LEFT);
        testValume.set_flippable(false);
        testValume.set_inverted(true);
      }
      testValume.connect('change-value', (scroll, value) => {
        valume = value;
      });
      boxH = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL });
      boxH.append(testValume);
      boxH.append(new Gtk.Label({ label: 'شدّت صدا:' }));
      box.append(boxH);
      */



      let playPauseBtn = new Gtk.Button({ label: 'پخش', margin_top: 14 });
      playPauseBtn.connect('clicked', () => {
        if (mStream && mStream.playing) {
          mStream.clear();
          mStream = null;
          playPauseBtn.label = 'پخش';
        } else if (selectedSoundUri !== '') {
          let file = Gio.File.new_for_uri('file://' + selectedSoundUri);
          mStream = Gtk.MediaFile.new_for_file(file);
          if (!file || !mStream) return;
          mStream.connect("notify::prepared", () => {
            if (mStream.has_audio) {
              mStream.play();
              playPauseBtn.label = 'توقّف';
            }
          });
          mStream.connect("notify::ended", () => {
            if (mStream.ended) {
              mStream.clear();
              mStream = null;
              playPauseBtn.label = 'پخش';
            }
          });
        }
      });
      box.append(playPauseBtn);

      box.append(new Gtk.Label({
        label: '<span size="large" color="#060">\nفایل‌های صوتی با پسوند ogg. پشتیبانی می‌شوند.</span>\n\n<span size="medium" color="#999">\nاین صفحه فقط برای شنیدن و آزمایش صداهاست.\nتغییر موارد بالا، هرگز در تنظیمات ذخیره نمی‌شود.</span>',
        use_markup: true
      }));

      dialog.get_content_area().append(box);

      dialog.connect('response', (dialog, id) => {
        if (id != 1) {
          if (mStream && mStream.playing) {
            mStream.clear();
            mStream = null;
          }
          //dialog.get_content_area().remove(box);
          //dialog.destroy();
        }
        return;
      });

      dialog.present();
    });





    /*
    // this option removed!
    this.el['praytime-play-valume'] = new Gtk.Scale;
    this.el['praytime-play-valume'].set_size_request(220, 14);
    this.el['praytime-play-valume'].set_range(0.0, 1.0);
    this.el['praytime-play-valume'].set_value(this.schema.get_double('praytime-play-valume'));
    const DEFAULT_ICONS_SIZES = [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0];
    for (let i in DEFAULT_ICONS_SIZES) {
      this.el['praytime-play-valume'].add_mark(DEFAULT_ICONS_SIZES[i], Gtk.PositionType.TOP, '');
    }
    this._rtl = (Gtk.Widget.get_default_direction() == Gtk.TextDirection.RTL);
    if (this._rtl) {
      this.el['praytime-play-valume'].set_value_pos(Gtk.PositionType.LEFT);
      this.el['praytime-play-valume'].set_flippable(false);
      this.el['praytime-play-valume'].set_inverted(true);
    }
    this.el['praytime-play-valume'].connect('value-changed', () => {
      this.schema.set_double('praytime-play-valume', this.el['praytime-play-valume'].get_value());
    });
    this.el['label_praytime-play-valume'] = new Gtk.Label({ label: 'شدّت صدا:' });
    */

    this.el['praytime-play-and-notify'] = new Gtk.CheckButton({ label: 'اعلان و پخش اذان' });
    this.schema.bind('praytime-play-and-notify', this.el['praytime-play-and-notify'], 'active', Gio.SettingsBindFlags.DEFAULT);

    hbox.append(new Gtk.Label({
      label: '<span color="#aaa">\nفایل‌های صوتی با پسوند ogg. پشتیبانی می‌شوند.</span>',
      use_markup: true
    }));
    hbox.append(playSounds);
    hbox.append(this.el['praytime-play-and-notify']);
    // hbox.append(this.el['praytime-play-valume']); // this option removed!
    // hbox.append(this.el['label_praytime-play-valume']); // this option removed!

    this.vbox5.append(hbox);










    // Reset Settings
    this.vbox6.set_spacing(1);

    this.vbox6.append(new Gtk.Label({
      label: 'با انجام عمل بازنشانی، تنظیمات این افزونه به حالت پیشفرض اوّلیه باز خواهد گردید.',
      use_markup: true
    }));

    this.vbox6.append(new Gtk.Separator({ orientation: Gtk.Orientation.HORIZONTAL, margin_top: 8, margin_bottom: 8 }));

    let resetBtn = new Gtk.Button({ label: 'بازنشانی تنظیمات بخش «ابزارک نوار»' });
    resetBtn.connect('clicked', () => this._resetConfig(['vbox1']));
    this.vbox6.append(resetBtn);

    resetBtn = new Gtk.Button({ label: 'بازنشانی تنظیمات بخش «پنجره تقویم»' });
    resetBtn.connect('clicked', () => this._resetConfig(['vbox2']));
    this.vbox6.append(resetBtn);

    resetBtn = new Gtk.Button({ label: 'بازنشانی تنظیمات بخش «مناسبت‌ها»' });
    resetBtn.connect('clicked', () => this._resetConfig(['vbox3']));
    this.vbox6.append(resetBtn);

    resetBtn = new Gtk.Button({ label: 'بازنشانی تنظیمات بخش «هفته»' });
    resetBtn.connect('clicked', () => this._resetConfig(['vbox4']));
    this.vbox6.append(resetBtn);

    resetBtn = new Gtk.Button({ label: 'بازنشانی تنظیمات «اوقات شرعی»، بخش عادی' });
    resetBtn.connect('clicked', () => this._resetConfig(['vbox5']));
    this.vbox6.append(resetBtn);

    resetBtn = new Gtk.Button({ label: 'بازنشانی بخش «تنظیمات پیشرفته» اوقات شرعی' });
    resetBtn.connect('clicked', () => this._resetPrayTimesAdvanceSettings());
    this.vbox6.append(resetBtn);

    this.vbox6.append(new Gtk.Separator({ orientation: Gtk.Orientation.HORIZONTAL, margin_top: 8, margin_bottom: 8 }));

    resetBtn = new Gtk.Button({ label: '\nبازنشانی همه‌ی تنظیمات بالا به‌صورت یکجا\n' });
    resetBtn.connect('clicked', () => {
      this._resetConfig();
      this._resetPrayTimesAdvanceSettings();
    });
    this.vbox6.append(resetBtn);










    // About
    this.vbox7.append(new Gtk.Label({
      label: 'افزونه‌ی تقویم هجری شمسی، قمری و میلادی برای میز‌کار گنوم لینوکس',
      use_markup: true
    }));

    this.vbox7.append(new Gtk.Separator({ orientation: Gtk.Orientation.HORIZONTAL, margin_top: 8, margin_bottom: 8 }));

    this.vbox7.append(new Gtk.Label({
      label: 'صفحه‌ی رسمی (دریافت آخرین نسخه):\n<a href="https://jdf.scr.ir/gnome_shamsi_calendar">https://jdf.scr.ir/gnome_shamsi_calendar</a>\n\nحمایت مالی:\n<a href="https://scr.ir/pardakht/?hemayat=gnome_shamsi_calendar">https://scr.ir/pardakht/?hemayat=gnome_shamsi_calendar</a>\n\nصفحه‌ی گنوم:\n<a href="https://extensions.gnome.org/extension/3618/">https://extensions.gnome.org/extension/3618</a>\n\nکد منبع:\n<a href="https://github.com/scr-ir/gnome-shamsi-calendar/">https://github.com/scr-ir/gnome-shamsi-calendar</a>',
      use_markup: true
    }));



  }

  _resetPrayTimesAdvanceSettings() {
    for (let tName in this.NewPrayTimes.persianMap) {
      this.schema.reset('praytime-' + tName + '-setting');
      this.schema.reset('praytime-' + tName + '-sound-uri');
      if (this.el['praytime-imsak-setting_ShowTime'] === undefined) continue;
      const settings = getPrayTimeSetting(tName, this.schema);
      // this.schema: Times Setting value="ShowTime,TextNotify,PlaySound,CalcMethod,SoundId"
      ['ShowTime', 'TextNotify', 'PlaySound', 'CalcMethod', 'SoundId'].forEach((indexId) => {
        this.el['praytime-' + tName + '-setting_' + indexId].set_active_id(settings[indexId]);
      });
      let SoundUri = this.schema.get_string('praytime-' + tName + '-sound-uri');
      if (this.el['praytime-' + tName + '-setting_SoundId'].get_active_id().toString() === '_custom_') {
        if (SoundUri === '' || SoundUri === 'Music') {
          this.btnIconLabel(this.el['praytime-' + tName + '-sound-uri'], '');
        } else {
          fileName = SoundUri.slice(0, SoundUri.lastIndexOf('.'));
          fileName = fileName.slice(fileName.lastIndexOf('/') + 1);
          if (fileName.length > 8) fileName = fileName.slice(0, 8) + '...';
          this.btnIconLabel(this.el['praytime-' + tName + '-sound-uri'], fileName);
        }
      } else {
        this.el['praytime-' + tName + '-sound-uri'].set_label('  →  غیرفعال  ');
      }
    }
  }

  _resetConfig(sections = ['vbox1', 'vbox2', 'vbox3', 'vbox4', 'vbox5']) {
    const keysObj = {
      vbox1: {
        'widget-format': 'ComboBoxText',
        'widget-position': 'ComboBoxText',
        'pray-time-color': 'ColorButton',
        'holiday-color': 'ColorButton',
        'not-holiday-color': 'ColorButton',
        'custom-color': 'CheckButton',
        'startup-notification': 'CheckButton'
      },
      vbox2: {
        'window-position': 'ComboBoxText',
        'dark-theme-id': 'CheckButton',// <- i <- ComboBoxText
        'light-theme-id': 'CheckButton',// <- i <- ComboBoxText
        'default-tab': 'ComboBoxText',
        'persian-display-format': 'ComboBoxText',
        'persian-display': 'CheckButton',
        'islamic-display-format': 'ComboBoxText',
        'islamic-display': 'CheckButton',
        'gregorian-display-format': 'ComboBoxText',
        'gregorian-display': 'CheckButton'
      },
      vbox3: {
        'show-persian-events': 'CheckButton',
        'show-islamic-events': 'CheckButton',
        'show-gregorian-events': 'CheckButton',
        'show-old-events': 'CheckButton'
      },
      vbox4: {
        'week-start': 'ComboBoxText',
        'none-work-0': 'CheckButton',
        'none-work-1': 'CheckButton',
        'none-work-2': 'CheckButton',
        'none-work-3': 'CheckButton',
        'none-work-4': 'CheckButton',
        'none-work-5': 'CheckButton',
        'none-work-6': 'CheckButton',
        'reverse-direction': 'CheckButton',
        'rotaton-to-vertical': 'CheckButton'
      },
      vbox5: {
        'praytime-calc-method-main': 'ComboBoxText',
        'praytime-calc-method-ehtiyat': 'ComboBoxText',
        'praytime-ehtiyat-show': 'CheckButton',
        'praytime-lat': 'Entry-Double',
        'praytime-lng': 'Entry-Double',
        'praytime-city': 'Entry-String',
        'praytime-state': '_only_reset_schema_',
        // 'praytime-play-valume': 'Scale', // this option removed!
        'praytime-play-and-notify': 'CheckButton'
      }
    };


    for (let i in sections) {
      for (let key in keysObj[sections[i]]) {
        this.schema.reset(key);
        switch (keysObj[sections[i]][key]) {
          case 'Entry-String':
            this.el[key].set_text(this.schema.get_string(key));
            break;
          case 'Entry-Double':
            this.el[key].set_text(this.schema.get_double(key).toString());
            break;
          case 'CheckButton':
            this.schema.bind(key, this.el[key], 'active', Gio.SettingsBindFlags.DEFAULT);
            break;
          case 'ColorButton':
            this.el[key].set_modal(this.getColorByHexadecimal(this.schema.get_string(key)));
            break;
          case 'ComboBoxText':
            this.schema.bind(key, this.el[key], 'active-id', Gio.SettingsBindFlags.DEFAULT);
            break;
          case 'Scale':
            this.el[key].set_value(this.schema.get_double(key));
            break;
        }
      }
    }
  }

  setPrayTimeSetting(tName, indexId, value) {
    indexId = indexId.toString();
    // this.schema: Times Setting value="ShowTime,TextNotify,PlaySound,CalcMethod,SoundId"
    const indexIds = {
      ShowTime: 0,
      TextNotify: 1,
      PlaySound: 2,
      CalcMethod: 3,
      SoundId: 4
    };
    let setting = this.schema.get_string('praytime-' + tName + '-setting').split(',');
    setting[indexIds[indexId]] = value;
    this.schema.set_string('praytime-' + tName + '-setting', setting.join(','));
  }

  btnIconLabel(btn, label = '') {
    let boxH = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL });
    boxH.append(new Gtk.Image({ icon_name: (label === '') ? 'folder' : 'audio-x-generic' }));
    boxH.append(new Gtk.Label({ label: ' ' + ((label === '') ? 'انتخاب' : label) + ' ' }));
    btn.set_child(boxH);
  }

  createTextEntry(value, labelText, commentText) {
    let label = new Gtk.Label({ label: labelText });
    let format = new Gtk.Entry();
    let hbox = new Gtk.Box({ orientation: Gtk.Orientation.HORIZONTAL, spacing: 0 });
    hbox.append(label);
    hbox.append(format);
    let comment = null;
    if (commentText)
      comment = new Gtk.Label({
        label: commentText,
        use_markup: true
      });
    format.set_text(this.schema.get_double(value).toString());
    format.connect('changed', function (innerFormat) {
      this.schema.set_string(value, innerFormat.text);
    });

    return { hbox: hbox, comment: comment };
  }

  _dec2Hex(value) {
    value = parseInt(value * 255).toString(16);
    while (value.length < 2) {
      value = '0' + value;
    }
    return value;
  }

  getColorByHexadecimal(hex) {
    let color = new Gdk.RGBA();
    color.parse(hex);
    if (!color) color.parse('#cc0000');
    return color;
  }

  getHexadecimalByColor(color) {
    return '#' + this._dec2Hex(color.red) + this._dec2Hex(color.green) + this._dec2Hex(color.blue);
  }

}
