

import Clutter from 'gi://Clutter';
import * as Main from 'resource:///org/gnome/shell/ui/main.js';
import * as IconGrid from 'resource:///org/gnome/shell/ui/iconGrid.js';
import * as OverviewControls from 'resource:///org/gnome/shell/ui/overviewControls.js';
import { Extension } from 'resource:///org/gnome/shell/extensions/extension.js';

let appGridTweaker = null;

class AppGridTweaks {

  constructor(settings) {
  
    this.settings = settings;
    
  }

  applyFolderViewChanges() {
  
    const MainAppDisplay = Main.overview._overview._controls._appDisplay;
    MainAppDisplay._folderIcons.forEach(icon => {
      icon.view._grid.layout_manager.fixedIconSize = this.iconSize;
      icon.view._grid.layout_manager.rowsPerPage = (Math.ceil(icon.getAppIds().length / this.fColumns) < this.fRows) ? Math.ceil(icon.getAppIds().length / this.fColumns) : this.fRows;
      icon.view._grid.layout_manager.columnsPerPage = (icon.getAppIds().length > this.fColumns) ? this.fColumns : icon.getAppIds().length;
      icon._ensureFolderDialog();
      icon._dialog._popdownCallbacks = [];   
      icon._dialog.child.style = "height: "+(icon.view._grid.layout_manager.rowsPerPage*(this.iconSize+72)+152)+"px; width: "+Math.max(icon.view._grid.layout_manager.columnsPerPage*(this.iconSize+78)+202, 640)+"px;";
      icon.view._redisplay();
    });  
  
  }

  startAppGridTweaks() {
 
    const MainAppDisplay = Main.overview._overview._controls._appDisplay;
    let appGrid = MainAppDisplay._grid;

    if (this.reloadSignal) {
      this.settings.disconnect(this.reloadSignal);
      this.reloadSignal = 0;
    }

    this.reloadSignal = this.settings.connect('changed::reload-signal', () => {
      this.undoChanges();
      this.startAppGridTweaks();
    });

    const gridRows = this.settings.get_int("appgrid-max-rows");
    const gridCols = this.settings.get_int("appgrid-max-columns");
    [appGrid.style, this.iconSize, this.fRows, this.fColumns, this.sidePadding] = ["font-size: "+this.settings.get_double("app-icon-font-size")+"px;"+this.settings.get_string("label-style"), this.settings.get_int("appgrid-icon-size"), this.settings.get_int("folder-max-rows"), this.settings.get_int("folder-max-columns"), this.settings.get_int("side-padding")];
    this.openAnimationTime = this.settings.get_int("open-animation-time");
    this.pageSwitchAnimationTime = this.settings.get_int("page-switch-animation-time");
    appGrid.layout_manager.fixedIconSize = this.iconSize;
      
    this.defaultAdaptToSizeFunction = MainAppDisplay.adaptToSize;
    MainAppDisplay.adaptToSize = this.overriddenAdaptToSizeFunction;     

    if(MainAppDisplay._folderIcons.length > 0) {
      this.applyFolderViewChanges();
    }
     
    if (this.reloadingSig)
      MainAppDisplay.disconnect(this.reloadingSig);

    this.reloadingSig = MainAppDisplay.connect("view-loaded", ()=> {
      this.applyFolderViewChanges();  
      this.updatePages();
    });   

    // Apply grid modes via API and enforce mode 0
    if (typeof appGrid.setGridModes === 'function')
      appGrid.setGridModes([{ rows: gridRows, columns: gridCols }]);
    else
      appGrid._gridModes[0] = { rows: gridRows, columns: gridCols };

    appGrid._currentMode = 0; 
    appGrid.layout_manager.rowsPerPage      = gridRows;
    appGrid.layout_manager.columnsPerPage   = gridCols;

    // Force re-layout and icon size recomputation
    appGrid.layout_manager.fixedIconSize = this.iconSize;
    appGrid.layout_manager._pageWidth--; // trigger adaptToSize path
    appGrid.layout_manager.adaptToSize(appGrid.layout_manager._pageWidth, appGrid.layout_manager._pageHeight);

    this.updatePages();
    MainAppDisplay._redisplay();

  }
  
  updatePages() {  
  
    const MainAppDisplay = Main.overview._overview._controls._appDisplay;
    for(let i = 0; i < MainAppDisplay._grid.layout_manager._pages.length; i++)
      MainAppDisplay._grid.layout_manager._fillItemVacancies(i);   
    MainAppDisplay._grid.layout_manager._updatePages();
    for(let i = 0; i < MainAppDisplay._grid.layout_manager._pages.length; i++)
      MainAppDisplay._grid.layout_manager._fillItemVacancies(i);
      
  }
  
  undoChanges() {
    
    const MainAppDisplay = Main.overview._overview._controls._appDisplay;
    let appGrid = MainAppDisplay._grid; 
    appGrid.layout_manager._pageWidth--;
    if (this.reloadingSig) {
      MainAppDisplay.disconnect(this.reloadingSig);
      this.reloadingSig = 0;
    }
    if (this.defaultAdaptToSizeFunction)
      MainAppDisplay.adaptToSize = this.defaultAdaptToSizeFunction;  
    appGrid.layout_manager.fixedIconSize = -1;
    [appGrid._gridModes[0].rows, appGrid._gridModes[0].columns] = [8, 3];
    MainAppDisplay._grid.layout_manager.adaptToSize(appGrid.layout_manager._pageWidth, appGrid.layout_manager._pageHeight);
    appGrid.style = "";   
    this.updatePages();  
    MainAppDisplay._redisplay(); 
    
  }

  destroy() {
    this.undoChanges();
    if (this.reloadSignal) {
      this.settings.disconnect(this.reloadSignal);
      this.reloadSignal = 0;
    }
    this.settings = null;
  }
  
  overriddenAdaptToSizeFunction(width, height) {

    const MainAppDisplay = Main.overview._overview._controls._appDisplay;
    const [, indicatorHeight] = this._pageIndicators.get_preferred_height(-1);
    height -= indicatorHeight;
 
    let box = new Clutter.ActorBox({
      x2: width,
      y2: height,
    });
    
    box = MainAppDisplay.get_theme_node().get_content_box(box);
    box = MainAppDisplay._scrollView.get_theme_node().get_content_box(box);
    box = MainAppDisplay._grid.get_theme_node().get_content_box(box);

    const availWidth = box.get_width();
    const availHeight = box.get_height();

    let pageHeight = availHeight;
    let hPadding   = appGridTweaker.sidePadding;
    let pageWidth  = availWidth-hPadding*2;

    MainAppDisplay._grid.layout_manager.adaptToSize(pageWidth, pageHeight);

    const vPadding = Math.floor((availHeight - MainAppDisplay._grid.layout_manager.pageHeight) / 2);

    MainAppDisplay._scrollView.content_padding = new Clutter.Margin({
      left: hPadding,
      right: hPadding,
      top: vPadding,
      bottom: vPadding,
    });

    MainAppDisplay._availWidth = availWidth;
    MainAppDisplay._availHeight = availHeight;

    MainAppDisplay._pageIndicatorOffset = hPadding;
    MainAppDisplay._pageArrowOffset = Math.max(hPadding - 80/*PAGE_PREVIEW_MAX_ARROW_OFFSET*/, 0);
  
  }  
    
}

export default class AppGridTweaksExtension extends Extension {
  enable() {
    const settings = this.getSettings();
    appGridTweaker = new AppGridTweaks(settings);
    appGridTweaker.startAppGridTweaks();
  }

  disable() {
    appGridTweaker?.destroy();
    appGridTweaker = null;
  }
}
