

import Gtk from 'gi://Gtk';
import Gio from 'gi://Gio';
import GLib from 'gi://GLib';
import GObject from 'gi://GObject';
import Adw from 'gi://Adw';
import { ExtensionPreferences, gettext as _ } from 'resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js';

const SETTINGS_APPLY_DELAY_TIME = 500;

export default class AppGridTweaksPrefs extends ExtensionPreferences {
  fillPreferencesWindow(window) {
    const settings = this.getSettings();

    let reloadSourceId = null;
    const scheduleReload = () => {
      if (reloadSourceId)
        GLib.source_remove(reloadSourceId);
      reloadSourceId = GLib.timeout_add(GLib.PRIORITY_DEFAULT, SETTINGS_APPLY_DELAY_TIME, () => {
        settings.set_boolean('reload-signal', !settings.get_boolean('reload-signal'));
        reloadSourceId = null;
        return GLib.SOURCE_REMOVE;
      });
    };

    const addSpinIntRow = (group, key, min, max, step) => {
      const row = new Adw.ActionRow({
        title: settings.settings_schema.get_key(key).get_summary(),
      });
      const spin = Gtk.SpinButton.new_with_range(min, max, step);
      spin.set_value(settings.get_int(key));
      spin.connect('notify::value', (w) => {
        settings.set_int(key, w.get_value_as_int());
        scheduleReload();
      });
      spin.set_valign(Gtk.Align.CENTER);
      row.add_suffix(spin);
      group.add(row);
    };

    const addSpinDoubleRow = (group, key, min, max, step) => {
      const row = new Adw.ActionRow({
        title: settings.settings_schema.get_key(key).get_summary(),
      });
      const spin = Gtk.SpinButton.new_with_range(min, max, step);
      spin.set_value(settings.get_double(key));
      spin.connect('notify::value', (w) => {
        settings.set_double(key, w.get_value());
        scheduleReload();
      });
      spin.set_valign(Gtk.Align.CENTER);
      row.add_suffix(spin);
      group.add(row);
    };

    const addComboRow = (group, key, options, labels) => {
      const row = new Adw.ActionRow({
        title: settings.settings_schema.get_key(key).get_summary(),
      });
      const combo = new Gtk.ComboBoxText();
      for (let i = 0; i < options.length; i++)
        combo.append(options[i], labels[i]);
      combo.set_active(options.indexOf(settings.get_string(key)));
      combo.connect('changed', (w) => {
        settings.set_string(key, options[w.get_active()]);
        scheduleReload();
      });
      combo.set_valign(Gtk.Align.CENTER);
      row.add_suffix(combo);
      group.add(row);
    };

    const page = new Adw.PreferencesPage();

    const appsGroup = new Adw.PreferencesGroup({ title: _('Apps') });
    addSpinIntRow(appsGroup, 'appgrid-max-rows', 1, 20, 1);
    addSpinIntRow(appsGroup, 'appgrid-max-columns', 1, 20, 1);
    addSpinIntRow(appsGroup, 'appgrid-icon-size', 32, 256, 1);
    addSpinIntRow(appsGroup, 'side-padding', 0, 256, 1);
    addSpinDoubleRow(appsGroup, 'app-icon-font-size', 0, 20, 0.1);
    addComboRow(
      appsGroup,
      'label-style',
      [
        'font-weight: normal;',
        'font-weight: normal; text-shadow: 2px 3px 3px #000000, 2px 3px 3px #000000;',
        'font-weight: bold;',
        'font-weight: bold; text-shadow: 2px 3px 3px #000000, 2px 3px 3px #000000;',
      ],
      [
        _('Normal'),
        _('Normal with Shadow'),
        _('Bold'),
        _('Bold with Shadow'),
      ],
    );
    addSpinIntRow(appsGroup, 'open-animation-time', 1, 10000, 1);
    addSpinIntRow(appsGroup, 'page-switch-animation-time', 1, 10000, 1);

    const foldersGroup = new Adw.PreferencesGroup({ title: _('Folders') });
    addSpinIntRow(foldersGroup, 'folder-max-rows', 1, 20, 1);
    addSpinIntRow(foldersGroup, 'folder-max-columns', 1, 20, 1);

    page.add(appsGroup);
    page.add(foldersGroup);

    window.add(page);
    window.set_default_size(700, 500);
  }
}
