# USD-ARS Dollar Rates

A GNOME Shell extension that displays various USD to ARS (Argentine Peso) exchange rates on your top panel.

## Features

- **Multiple Dollar Rates**: Displays all major Argentine dollar exchange rates including:
  - Official (Oficial)
  - Blue (parallel market)
  - MEP (Bolsa/Stock market)
  - CCL (Contado con liquidación)
  - Wholesale (Mayorista)
  - Crypto (Cripto)
  - Card (Tarjeta)

- **Auto-rotating Display**: Cycles through different dollar rates every 5 seconds
- **Real-time Updates**: Fetches fresh data from DolarAPI every 30 seconds
- **Clean Interface**: Minimalist display integrated into your GNOME top panel

## Supported GNOME Shell Versions

- GNOME Shell 44, 45, 46, 47, 48, 49

## Installation

### Method 1: Manual Installation

1. Clone or download this repository:
```bash
cd /tmp
git clone https://github.com/marcosreuquen/USD-ARS-GShell.git
```

2. Copy to GNOME extensions directory:
```bash
mkdir -p ~/.local/share/gnome-shell/extensions/
cp -r USD-ARS-GShell ~/.local/share/gnome-shell/extensions/usd-ars@marcosreuquen.github.io
```

3. Compile the GSettings schema (if present):
```bash
cd ~/.local/share/gnome-shell/extensions/usd-ars@marcosreuquen.github.io
glib-compile-schemas schemas/ 2>/dev/null || true
```

4. Enable the extension:
```bash
gnome-extensions enable usd-ars@marcosreuquen.github.io
```

5. Restart GNOME Shell:
   - **X11**: Press `Alt+F2`, type `r`, and press Enter
   - **Wayland**: Log out and log back in

### Method 2: Symbolic Link (For Development)

If you want to keep the extension files in your development directory:

```bash
ln -s /path/to/your/USD-ARS-GShell ~/.local/share/gnome-shell/extensions/usd-ars@marcosreuquen.github.io
gnome-extensions enable usd-ars@marcosreuquen.github.io
```

## Configuration

The extension works out of the box with default settings:
- Display rotation: Every 5 seconds
- Data update: Every 30 seconds
- Panel position: Center

## Data Source

This extension uses [DolarAPI](https://dolarapi.com/), a free API that provides real-time Argentine peso exchange rates.

- API Documentation: https://dolarapi.com/docs/argentina/
- API Endpoint: https://dolarapi.com/v1/dolares

## Troubleshooting

### Extension not showing up

1. Check if the extension is enabled:
```bash
gnome-extensions list --enabled
```

2. View extension errors:
```bash
journalctl -f -o cat /usr/bin/gnome-shell
```

### Error loading rates

- Ensure you have an active internet connection
- Check if DolarAPI is accessible: https://dolarapi.com/v1/dolares
- Look for errors in the logs using the command above

## Development

### File Structure

```
usd-ars@marcosreuquen.github.io/
├── extension.js       # Main extension code
├── metadata.json      # Extension metadata
├── stylesheet.css     # Custom styles
├── LICENSE           # GPL-3.0 license
└── README.md         # This file
```

### Making Changes

After modifying the extension:

1. Reload GNOME Shell (X11: `Alt+F2` → `r`, Wayland: logout/login)
2. Or disable and re-enable the extension:
```bash
gnome-extensions disable usd-ars@marcosreuquen.github.io
gnome-extensions enable usd-ars@marcosreuquen.github.io
```

## License

This project is licensed under the GPL-3.0 License - see the [LICENSE](LICENSE) file for details.

## Credits

- Original USD-TRY extension by [arifesat](https://github.com/arifesat/USD-TRY-GShell)
- EUR-USD fork by [vezza](https://github.com/vezza)
- Current USD-ARS implementation by [Marcos Reuquen](https://github.com/marcosreuquen)
- Exchange rate data provided by [DolarAPI](https://dolarapi.com/)

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

## Support

If you encounter any issues or have suggestions, please open an issue on the [GitHub repository](https://github.com/marcosreuquen/USD-ARS-GShell/issues).
