import St from "gi://St";
import * as PanelMenu from "resource:///org/gnome/shell/ui/panelMenu.js";
import * as PopupMenu from "resource:///org/gnome/shell/ui/popupMenu.js";
import { Icons } from "../lib/icons.js";
import { logger } from "../utils/logger.js";
class VicinaeIndicator {
  indicator;
  extension;
  constructor(extension) {
    this.extension = extension;
    this.indicator = new PanelMenu.Button(0, "Vicinae Gnome Extension");
    this.setupUI();
    this.setupMenu();
  }
  setupUI() {
    new Icons(this.extension.path);
    const vicinaeIcon = Icons.get("vicinae");
    const icon = new St.Icon({
      gicon: vicinaeIcon,
      style_class: "system-status-icon"
    });
    this.indicator.add_child(icon);
  }
  setupMenu() {
    const settingsItem = new PopupMenu.PopupMenuItem("Settings");
    settingsItem.connect("activate", () => {
      logger.debug("Opening Vicinae settings");
      this.extension.openPreferences();
    });
    if (this.indicator.menu && "addMenuItem" in this.indicator.menu) {
      this.indicator.menu.addMenuItem(settingsItem);
    }
  }
  getButton() {
    return this.indicator;
  }
  destroy() {
    if (this.indicator) {
      this.indicator.destroy();
    }
  }
}
export {
  VicinaeIndicator
};
