import Clutter from "gi://Clutter";
import { logger } from "../../utils/logger.js";
class ClickHandler {
  constructor(windowManager, onClickOutside) {
    this.onClickOutside = onClickOutside;
    this.windowManager = windowManager;
  }
  buttonPressHandler;
  windowManager;
  enable() {
    try {
      this.buttonPressHandler = global.stage.connect(
        "captured-event",
        (_stage, event) => {
          if (event.type() === Clutter.EventType.BUTTON_PRESS) {
            this.handleClick();
          }
          return Clutter.EVENT_PROPAGATE;
        }
      );
      logger.info("ClickHandler: Click tracking enabled");
    } catch (error) {
      logger.error("ClickHandler: Error enabling click tracking", error);
      throw error;
    }
  }
  disable() {
    if (this.buttonPressHandler) {
      global.stage.disconnect(this.buttonPressHandler);
      this.buttonPressHandler = void 0;
    }
    logger.info("ClickHandler: Click tracking disabled");
  }
  handleClick() {
    const [x, y] = global.get_pointer();
    const windows = global.get_window_actors();
    const window = windows.find((actor) => {
      const win = actor.meta_window;
      if (!win) return false;
      const rect = win.get_frame_rect();
      return x >= rect.x && x <= rect.x + rect.width && y >= rect.y && y <= rect.y + rect.height;
    });
    const clickedWindow = window?.meta_window;
    const isTargetWindow = this.windowManager.isTargetWindow(
      clickedWindow?.get_wm_class() || ""
    );
    if (!clickedWindow || !isTargetWindow) {
      this.onClickOutside();
    }
  }
}
export {
  ClickHandler
};
