import { logger } from "../../utils/logger.js";
class FocusTracker {
  constructor(onFocusChange) {
    this.onFocusChange = onFocusChange;
  }
  focusHandler;
  enable() {
    try {
      this.focusHandler = global.display.connect(
        "notify::focus-window",
        (_display, _window) => {
          this.onFocusChange();
        }
      );
      logger.info("FocusTracker: Focus tracking enabled");
    } catch (error) {
      logger.error("FocusTracker: Error enabling focus tracking", error);
      throw error;
    }
  }
  disable() {
    if (this.focusHandler) {
      global.display.disconnect(this.focusHandler);
      this.focusHandler = void 0;
    }
    logger.info("FocusTracker: Focus tracking disabled");
  }
}
export {
  FocusTracker
};
