import Gio from "gi://Gio";
const ICONS = ["vicinae", "github"];
class Icons {
  static #icons = /* @__PURE__ */ new Map();
  constructor(extPath) {
    for (const name of ICONS) {
      const iconPath = `${extPath}/assets/icons/${name}.svg`;
      const icon = Gio.icon_new_for_string(iconPath);
      Icons.#icons.set(name, icon);
    }
  }
  static get(name) {
    return Icons.#icons.get(name);
  }
}
export {
  Icons
};
