import { getFocusedWindowApp } from "./window-utils.js";
const CLIPBOARD_CONFIG = {
  MAX_CLIPBOARD_SIZE: 10 * 1024 * 1024
  // 10MB - reasonable clipboard limit
};
function isValidImageBuffer(buffer) {
  if (!buffer) return false;
  let uint8Array;
  if (buffer instanceof ArrayBuffer) {
    if (buffer.byteLength < 8) return false;
    uint8Array = new Uint8Array(buffer);
  } else if (buffer instanceof Uint8Array) {
    if (buffer.length < 8) return false;
    uint8Array = buffer;
  } else if ("length" in buffer && buffer.length >= 8) {
    uint8Array = new Uint8Array(buffer.slice(0, 8));
  } else {
    return false;
  }
  if (uint8Array[0] === 137 && uint8Array[1] === 80 && uint8Array[2] === 78 && uint8Array[3] === 71) {
    return true;
  }
  if (uint8Array[0] === 255 && uint8Array[1] === 216 && uint8Array[2] === 255) {
    return true;
  }
  if (uint8Array[0] === 71 && uint8Array[1] === 73 && uint8Array[2] === 70 && uint8Array[3] === 56) {
    return true;
  }
  if (uint8Array[0] === 82 && uint8Array[1] === 73 && uint8Array[2] === 70 && uint8Array[3] === 70) {
    let webpCheck;
    if (buffer instanceof Uint8Array && buffer.length >= 12) {
      webpCheck = buffer.slice(8, 12);
    } else if (buffer instanceof ArrayBuffer && buffer.byteLength >= 12) {
      webpCheck = new Uint8Array(buffer.slice(8, 12));
    } else if ("length" in buffer && buffer.length >= 12) {
      webpCheck = new Uint8Array(buffer.slice(8, 12));
    } else {
      return false;
    }
    if (webpCheck[0] === 87 && webpCheck[1] === 69 && webpCheck[2] === 66 && webpCheck[3] === 80) {
      return true;
    }
  }
  return false;
}
function getImageMimeType(buffer) {
  if (!buffer) return "application/octet-stream";
  let uint8Array;
  if (buffer instanceof ArrayBuffer) {
    if (buffer.byteLength < 8) return "application/octet-stream";
    uint8Array = new Uint8Array(buffer.slice(0, 12));
  } else if (buffer instanceof Uint8Array) {
    if (buffer.length < 8) return "application/octet-stream";
    uint8Array = buffer.slice(0, 12);
  } else if ("length" in buffer && buffer.length >= 8) {
    uint8Array = new Uint8Array(buffer.slice(0, 12));
  } else {
    return "application/octet-stream";
  }
  if (uint8Array[0] === 137 && uint8Array[1] === 80 && uint8Array[2] === 78 && uint8Array[3] === 71) {
    return "image/png";
  }
  if (uint8Array[0] === 255 && uint8Array[1] === 216 && uint8Array[2] === 255) {
    return "image/jpeg";
  }
  if (uint8Array[0] === 71 && uint8Array[1] === 73 && uint8Array[2] === 70 && uint8Array[3] === 56) {
    return "image/gif";
  }
  if (uint8Array[0] === 82 && uint8Array[1] === 73 && uint8Array[2] === 70 && uint8Array[3] === 70) {
    let webpCheck;
    if (buffer instanceof Uint8Array && buffer.length >= 12) {
      webpCheck = buffer.slice(8, 12);
    } else if (buffer instanceof ArrayBuffer && buffer.byteLength >= 12) {
      webpCheck = new Uint8Array(buffer.slice(8, 12));
    } else if ("length" in buffer && buffer.length >= 12) {
      webpCheck = new Uint8Array(buffer.slice(8, 12));
    } else {
      return "application/octet-stream";
    }
    if (webpCheck[0] === 87 && webpCheck[1] === 69 && webpCheck[2] === 66 && webpCheck[3] === 80) {
      return "image/webp";
    }
  }
  return "application/octet-stream";
}
function calculateClipboardMetadata(event) {
  const content = event.content;
  let mimeType = "text/plain";
  const sourceApp = getFocusedWindowApp();
  if (event.source === "image") {
    if (content.startsWith("data:image/")) {
      const match = content.match(/^data:(image\/[^;]+);/);
      mimeType = match ? match[1] : "image/png";
    }
  } else if (content.startsWith("data:")) {
    const match = content.match(/^data:([^;]+);/);
    mimeType = match ? match[1] : "application/octet-stream";
  } else {
    mimeType = "text/plain";
    if (content.includes("<") && content.includes(">") && (content.includes("<html") || content.includes("<div") || content.includes("<p"))) {
      mimeType = "text/html";
    }
  }
  return {
    mimeType,
    sourceApp
  };
}
export {
  CLIPBOARD_CONFIG,
  calculateClipboardMetadata,
  getImageMimeType,
  isValidImageBuffer
};
