const getWindowById = (winid) => {
  if (!winid || winid <= 0) return null;
  try {
    const windowActors = global.get_window_actors();
    return windowActors.find((w) => {
      try {
        return w.meta_window && w.meta_window.get_id() === winid;
      } catch {
        return false;
      }
    });
  } catch (_error) {
    return null;
  }
};
const getCurrentWorkspace = () => {
  const workspaceManager = global.workspace_manager;
  return workspaceManager.get_active_workspace();
};
const getCurrentMonitor = () => {
  return global.display.get_current_monitor();
};
const getCurrentTime = () => {
  return global.get_current_time();
};
const getFocusedWindow = () => {
  const windowActors = global.get_window_actors();
  return windowActors.find((w) => w.meta_window.has_focus());
};
const getFocusedWindowApp = () => {
  const focusedWindow = getFocusedWindow();
  if (focusedWindow) {
    const wmClass = focusedWindow.meta_window.get_wm_class();
    const title = focusedWindow.meta_window.get_title();
    return wmClass || title || "unknown";
  }
  return "gnome-shell";
};
const isMaximized = (win) => {
  if (win.is_maximized !== void 0) {
    return win.is_maximized();
  }
  return win.get_maximized();
};
export {
  getCurrentMonitor,
  getCurrentTime,
  getCurrentWorkspace,
  getFocusedWindow,
  getFocusedWindowApp,
  getWindowById,
  isMaximized
};
