import './node_modules/@girs/gnome-shell/dist/extensions/extension.js';
import './node_modules/@girs/gnome-shell/dist/ui/main.js';
import { debug } from './utils/debug.js';
import Indicator from './modules/Indicator.js';
import ShortcutsHandler from './modules/ShortcutsHandler.js';
import { generateNanoIdWithSymbols } from './utils/helpers.js';
import { SETTINGS_KEYS } from './utils/constants.js';
import { Extension } from 'resource:///org/gnome/shell/extensions/extension.js';
import { panel } from 'resource:///org/gnome/shell/ui/main.js';

class QuickLofi extends Extension {
    _indicator = null;
    _settings = null;
    _shortcutsHandler = null;
    constructor(props) {
        super(props);
    }
    _migrateRadios() {
        const radios = this._settings.get_strv(SETTINGS_KEYS.RADIOS_LIST);
        const updatedRadios = radios.map((radio) => {
            if (radio.split(' - ').length === 3) {
                return radio;
            }
            if (radio.includes(' - ')) {
                const [name, url] = radio.split(' - ');
                const id = generateNanoIdWithSymbols(10);
                return `${name} - ${url} - ${id}`;
            }
        });
        if (JSON.stringify(radios) === JSON.stringify(updatedRadios))
            return;
        this._settings.set_strv(SETTINGS_KEYS.RADIOS_LIST, updatedRadios);
    }
    enable() {
        debug('extension enabled');
        this._settings = this.getSettings();
        this._settings.set_string(SETTINGS_KEYS.CURRENT_RADIO_PLAYING, '');
        this._migrateRadios();
        this._indicator = new Indicator(this);
        this._shortcutsHandler = new ShortcutsHandler(this._settings, this._indicator.mpvPlayer);
        panel.addToStatusArea(this.uuid, this._indicator);
    }
    disable() {
        this._indicator.dispose();
        this._indicator = null;
        this._settings = null;
        this._shortcutsHandler.destroy();
        this._shortcutsHandler = null;
    }
}

export { QuickLofi as default };
