import '../node_modules/@girs/gnome-shell/dist/ui/main.js';
import Gio from 'gi://Gio';
import Meta from 'gi://Meta';
import Shell from 'gi://Shell';
import { SHORTCUTS, SETTINGS_KEYS } from '../utils/constants.js';
import { wm } from 'resource:///org/gnome/shell/ui/main.js';

class ShortcutsHandler {
    _settings;
    _player;
    constructor(_settings, _player) {
        this._settings = _settings;
        this._player = _player;
        this.handleShortcuts();
    }
    handleShortcuts() {
        wm.addKeybinding(SHORTCUTS.PLAY_PAUSE_SHORTCUT, this._settings, Meta.KeyBindingFlags.IGNORE_AUTOREPEAT, Shell.ActionMode.NORMAL, () => {
            this._player.playPause();
        });
        wm.addKeybinding(SHORTCUTS.STOP_SHORTCUT, this._settings, Meta.KeyBindingFlags.IGNORE_AUTOREPEAT, Shell.ActionMode.NORMAL, () => {
            this._player.stopPlayer();
        });
        wm.addKeybinding(SHORTCUTS.INCREASE_VOLUME_SHORTCUT, this._settings, Meta.KeyBindingFlags.NONE, Shell.ActionMode.NORMAL, () => {
            const currentVolume = this._settings.get_int(SETTINGS_KEYS.VOLUME);
            if (currentVolume >= 100)
                return;
            const volumeStep = new Gio.Settings({ schema: 'org.gnome.settings-daemon.plugins.media-keys' }).get_int('volume-step');
            const newVolume = Math.floor(currentVolume + volumeStep);
            this._settings.set_int(SETTINGS_KEYS.VOLUME, newVolume);
        });
        wm.addKeybinding(SHORTCUTS.DECREASE_VOLUME_SHORTCUT, this._settings, Meta.KeyBindingFlags.NONE, Shell.ActionMode.NORMAL, () => {
            const currentVolume = this._settings.get_int(SETTINGS_KEYS.VOLUME);
            if (currentVolume <= 0)
                return;
            const volumeStep = new Gio.Settings({ schema: 'org.gnome.settings-daemon.plugins.media-keys' }).get_int('volume-step');
            const newVolume = Math.floor(currentVolume - volumeStep);
            this._settings.set_int(SETTINGS_KEYS.VOLUME, newVolume);
        });
    }
    _removeShortcuts() {
        Object.values(SHORTCUTS).forEach((key) => {
            wm.removeKeybinding(key);
        });
    }
    destroy() {
        this._removeShortcuts();
    }
}

export { ShortcutsHandler as default };
