import Gtk4 from 'gi://Gtk';
import Adw from 'gi://Adw';
import Gdk from 'gi://Gdk';
import GObject from 'gi://GObject';
import '../node_modules/@girs/gnome-shell/dist/extensions/prefs.js';
import { gettext } from 'resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js';

class ShortcutButton extends Gtk4.Button {
    _label;
    _settingsKey;
    _settings;
    static {
        GObject.registerClass({
            GTypeName: 'ShortcutButton',
        }, this);
    }
    constructor(settings, settingsKey) {
        super();
        this._settings = settings;
        this._settingsKey = settingsKey;
        const shortcut = settings.get_strv(settingsKey)[0] ?? '';
        this._label = new Gtk4.ShortcutLabel({
            disabled_text: gettext('New accelerator…'),
            accelerator: shortcut,
            valign: Gtk4.Align.CENTER,
        });
        this.set_child(this._label);
        this.set_cursor(new Gdk.Cursor({ name: 'pointer' }));
        this._settings.connect(`changed::${this._settingsKey}`, () => {
            this._label.set_accelerator(this._settings.get_strv(this._settingsKey)[0] ?? '');
        });
        this.connect('clicked', this._onClicked.bind(this));
    }
    _onClicked() {
        const controllerKey = new Gtk4.EventControllerKey();
        const content = new Adw.StatusPage({
            title: gettext('New accelerator'),
            icon_name: 'preferences-desktop-keyboard-shortcuts-symbolic',
            description: gettext('Backspace to clear'),
        });
        const shortcutEditor = new Adw.Window({
            modal: true,
            hideOnClose: true,
            transient_for: this.get_root(),
            widthRequest: 480,
            heightRequest: 320,
            content,
        });
        const updateLabel = () => {
            this._label.set_accelerator(this._settings.get_strv(this._settingsKey)[0] ?? '');
        };
        shortcutEditor.add_controller(controllerKey);
        controllerKey.connect('key-pressed', (_source, keyval, keycode, state) => {
            let mask = state & Gtk4.accelerator_get_default_mod_mask();
            mask &= ~Gdk.ModifierType.LOCK_MASK;
            const isValid = Gtk4.accelerator_valid(keyval, mask) || (keyval === Gdk.KEY_Tab && mask !== 0);
            const isForbidden = [
                Gdk.KEY_Home,
                Gdk.KEY_Left,
                Gdk.KEY_Up,
                Gdk.KEY_Right,
                Gdk.KEY_Down,
                Gdk.KEY_Page_Up,
                Gdk.KEY_Page_Down,
                Gdk.KEY_End,
                Gdk.KEY_Tab,
                Gdk.KEY_KP_Enter,
                Gdk.KEY_Return,
                Gdk.KEY_Mode_switch,
            ].includes(keyval);
            if (!mask && keyval === Gdk.KEY_Escape) {
                shortcutEditor.close();
                return Gdk.EVENT_STOP;
            }
            if (keyval === Gdk.KEY_BackSpace) {
                this._settings.set_strv(this._settingsKey, ['']);
                updateLabel();
                shortcutEditor.close();
                return Gdk.EVENT_STOP;
            }
            if (!isValid || isForbidden || (!keyval && !keycode)) {
                return Gdk.EVENT_STOP;
            }
            const val = Gtk4.accelerator_name_with_keycode(null, keyval, keycode, mask);
            this._settings.set_strv(this._settingsKey, [val]);
            updateLabel();
            shortcutEditor.close();
            return Gdk.EVENT_STOP;
        });
        shortcutEditor.present();
    }
    createRow(title, subtitle) {
        const row = new Adw.ActionRow({
            title: gettext(title),
            subtitle: subtitle ? gettext(subtitle) : '',
            activatable: true,
            activatableWidget: this,
        });
        row.add_suffix(this);
        return row;
    }
}

export { ShortcutButton };
