import GLib from 'gi://GLib';
import { SETTINGS_KEYS } from './constants.js';

function handleErrorRow(row, errorMessage) {
    const TIMEOUT_SECONDS = 3;
    const originalTitle = row.get_title();
    if (originalTitle === errorMessage)
        return;
    row.add_css_class('error');
    row.set_title(errorMessage);
    GLib.timeout_add_seconds(GLib.PRIORITY_HIGH, TIMEOUT_SECONDS, () => {
        row.set_title(originalTitle);
        row.remove_css_class('error');
        return GLib.SOURCE_REMOVE;
    });
}
function isCurrentRadioPlaying(settings, radioID) {
    const current = settings.get_string(SETTINGS_KEYS.CURRENT_RADIO_PLAYING);
    return current.length > 0 && current === radioID;
}
function generateNanoIdWithSymbols(size) {
    const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=[]{}|;:,.<>?';
    return Array.from({ length: size }, () => chars.charAt(Math.floor(Math.random() * chars.length))).join('');
}

export { generateNanoIdWithSymbols, handleErrorRow, isCurrentRadioPlaying };
