import Gio from "gi://Gio";
const ICONS = [
  "left-arrow",
  "right-arrow",
  "arrow-open",
  "arrow-close"
];
class Icons {
  static #icons = /* @__PURE__ */ new Map();
  constructor(extPath) {
    for (const name of ICONS) {
      const icon = Gio.icon_new_for_string(
        `${extPath}/assets/icons/${name}.svg`
      );
      Icons.#icons.set(name, icon);
    }
  }
  static get(name) {
    return Icons.#icons.get(name);
  }
}
export {
  Icons
};
