import Adw from "gi://Adw";
import GObject from "gi://GObject";
import { getTemplate } from "../utils/getTemplate.js";
import { logger } from "../utils/logger.js";
const GeneralPage = GObject.registerClass(
  {
    GTypeName: "VeilGeneralPage",
    Template: getTemplate("GeneralPage"),
    InternalChildren: [
      "saveState",
      "defaultVisibility",
      "autoHideEnabled",
      "autoHideDuration",
      "animationEnabled",
      "animationDuration",
      "loggingLevel",
      "journalctlCommand"
    ]
  },
  class GeneralPage2 extends Adw.PreferencesPage {
    settings;
    bindSettings(settings) {
      this.settings = settings;
      const children = this;
      logger.debug("Settings bound to GeneralPage");
      const saveState = settings.get_boolean("save-state");
      children._saveState.set_selected(saveState ? 1 : 0);
      children._saveState.connect("notify::selected", () => {
        const selectedIndex = children._saveState.get_selected();
        settings.set_boolean("save-state", selectedIndex === 1);
        logger.debug("Save state changed", { saveState: selectedIndex === 1 });
      });
      const defaultVisibility = settings.get_boolean("default-visibility");
      children._defaultVisibility.set_selected(defaultVisibility ? 0 : 1);
      children._defaultVisibility.connect("notify::selected", () => {
        const selectedIndex = children._defaultVisibility.get_selected();
        settings.set_boolean("default-visibility", selectedIndex === 0);
        logger.debug("Default visibility changed", {
          visible: selectedIndex === 0
        });
      });
      const autoHideEnabled = settings.get_boolean("auto-hide-enabled");
      children._autoHideEnabled.set_active(autoHideEnabled);
      children._autoHideDuration.set_sensitive(autoHideEnabled);
      children._autoHideEnabled.connect("notify::active", () => {
        const isActive = children._autoHideEnabled.get_active();
        settings.set_boolean("auto-hide-enabled", isActive);
        children._autoHideDuration.set_sensitive(isActive);
        logger.debug("Auto-hide enabled changed", { enabled: isActive });
      });
      const autoHideDuration = settings.get_int("auto-hide-duration");
      children._autoHideDuration.set_value(autoHideDuration);
      children._autoHideDuration.connect("notify::value", () => {
        const value = children._autoHideDuration.get_value();
        settings.set_int("auto-hide-duration", value);
        logger.debug("Auto-hide duration changed", { duration: value });
      });
      const animationEnabled = settings.get_boolean("animation-enabled");
      children._animationEnabled.set_active(animationEnabled);
      children._animationDuration.set_sensitive(animationEnabled);
      children._animationEnabled.connect("notify::active", () => {
        const isActive = children._animationEnabled.get_active();
        settings.set_boolean("animation-enabled", isActive);
        children._animationDuration.set_sensitive(isActive);
        logger.debug("Animation enabled changed", { enabled: isActive });
      });
      const animationDuration = settings.get_int("animation-duration");
      children._animationDuration.set_value(animationDuration);
      children._animationDuration.connect("notify::value", () => {
        const value = children._animationDuration.get_value();
        settings.set_int("animation-duration", value);
        logger.debug("Animation duration changed", { duration: value });
      });
      const loggingLevels = ["error", "warn", "info", "debug"];
      const currentLevel = settings.get_string("logging-level");
      const currentIndex = loggingLevels.indexOf(currentLevel);
      children._loggingLevel.set_selected(currentIndex >= 0 ? currentIndex : 2);
      children._loggingLevel.connect("notify::selected", () => {
        const selectedIndex = children._loggingLevel.get_selected();
        if (selectedIndex >= 0 && selectedIndex < loggingLevels.length) {
          settings.set_string("logging-level", loggingLevels[selectedIndex]);
        }
      });
    }
  }
);
export {
  GeneralPage
};
