import { Extension } from 'resource:///org/gnome/shell/extensions/extension.js';
import Keybindings from './keybindings.js';
import Tile from './tile.js';

export default class SmartTilingExtension extends Extension {
  keybindings = null;
  gnomeKeybindingsSettings = null;
  mutterKeybindingsSettings = null;

  moveWindowRight() {
    const tile = new Tile();
    if (tile.position === 'top-left') {
      return tile.move('top');
    }
    if (tile.position === 'top') {
      return tile.move('top-right');
    }
    if (tile.position === 'bottom-left') {
      return tile.move('bottom');
    }
    if (tile.position === 'bottom') {
      return tile.move('bottom-right');
    }
    return tile.move('right');
  }

  moveWindowLeft() {
    const tile = new Tile();
    if (tile.position === 'top-right') {
      return tile.move('top');
    }
    if (tile.position === 'top') {
      return tile.move('top-left');
    }
    if (tile.position === 'bottom-right') {
      return tile.move('bottom');
    }
    if (tile.position === 'bottom') {
      return tile.move('bottom-left');
    }
    return tile.move('left');
  }

  moveWindowUp() {
    const tile = new Tile();
    if (tile.position === 'bottom-left') {
      return tile.move('left');
    }
    if (tile.position === 'left') {
      return tile.move('top-left');
    }
    if (tile.position === 'bottom-right') {
      return tile.move('right');
    }
    if (tile.position === 'right') {
      return tile.move('top-right');
    }
    if (tile.position === 'top') {
      return tile.move('maximized');
    }
    return tile.move('top');
  }

  moveWindowDown() {
    const tile = new Tile();
    if (tile.position === 'top-left') {
      return tile.move('left');
    }
    if (tile.position === 'left') {
      return tile.move('bottom-left');
    }
    if (tile.position === 'top-right') {
      return tile.move('right');
    }
    if (tile.position === 'right') {
      return tile.move('bottom-right');
    }
    if (tile.position === 'maximized') {
      return tile.move('top');
    }
    return tile.move('bottom');
  }

  enable() {
    this.gnomeKeybindingsSettings = this.getSettings('org.gnome.desktop.wm.keybindings');
    this.mutterKeybindingsSettings = this.getSettings('org.gnome.mutter.keybindings');
    this.gnomeKeybindingsSettings.set_strv('maximize', []);
    this.gnomeKeybindingsSettings.set_strv('unmaximize', []);
    this.mutterKeybindingsSettings.set_strv('toggle-tiled-left', []);
    this.mutterKeybindingsSettings.set_strv('toggle-tiled-right', []);
    this.keybindings = new Keybindings(this.getSettings());
    this.keybindings.add('move-window-right', this.moveWindowRight);
    this.keybindings.add('move-window-left', this.moveWindowLeft);
    this.keybindings.add('move-window-up', this.moveWindowUp);
    this.keybindings.add('move-window-down', this.moveWindowDown);
  }

  disable() {
    this.keybindings?.destroy();
    this.gnomeKeybindingsSettings?.reset('maximize');
    this.gnomeKeybindingsSettings?.reset('unmaximize');
    this.mutterKeybindingsSettings?.reset('toggle-tiled-left');
    this.mutterKeybindingsSettings?.reset('toggle-tiled-right');
    this.keybindings = null;
    this.gnomeKeybindingsSettings = null;
    this.mutterKeybindingsSettings = null;
  }
}
