import { Extension } from 'resource:///org/gnome/shell/extensions/extension.js';
import Keybindings from './keybindings.js';
import Tile from './tile.js';

export default class SmartTilingExtension extends Extension {
  keybindings = null;
  gnomeKeybindingsSettings = null;
  mutterKeybindingsSettings = null;
  tile = null;

  moveWindowRight() {
    if (this.tile?.position === 'top-left') {
      return this.tile?.move('top');
    }
    if (this.tile?.position === 'top') {
      return this.tile?.move('top-right');
    }
    if (this.tile?.position === 'bottom-left') {
      return this.tile?.move('bottom');
    }
    if (this.tile?.position === 'bottom') {
      return this.tile?.move('bottom-right');
    }
    return this.tile?.move('right');
  }

  moveWindowLeft() {
    if (this.tile?.position === 'top-right') {
      return this.tile?.move('top');
    }
    if (this.tile?.position === 'top') {
      return this.tile?.move('top-left');
    }
    if (this.tile?.position === 'bottom-right') {
      return this.tile?.move('bottom');
    }
    if (this.tile?.position === 'bottom') {
      return this.tile?.move('bottom-left');
    }
    return this.tile?.move('left');
  }

  moveWindowUp() {
    if (this.tile?.position === 'bottom-left') {
      return this.tile?.move('left');
    }
    if (this.tile?.position === 'left') {
      return this.tile?.move('top-left');
    }
    if (this.tile?.position === 'bottom-right') {
      return this.tile?.move('right');
    }
    if (this.tile?.position === 'right') {
      return this.tile?.move('top-right');
    }
    if (this.tile?.position === 'top') {
      return this.tile?.move('maximized');
    }
    return this.tile?.move('top');
  }

  moveWindowDown() {
    if (this.tile?.position === 'top-left') {
      return this.tile?.move('left');
    }
    if (this.tile?.position === 'left') {
      return this.tile?.move('bottom-left');
    }
    if (this.tile?.position === 'top-right') {
      return this.tile?.move('right');
    }
    if (this.tile?.position === 'right') {
      return this.tile?.move('bottom-right');
    }
    if (this.tile?.position === 'maximized') {
      return this.tile?.move('top');
    }
    return this.tile?.move('bottom');
  }

  handleMove(callback) {
    return () => {
      this.tile?.destroy();
      this.tile = new Tile();
      callback();
    };
  }

  enable() {
    this.gnomeKeybindingsSettings = this.getSettings('org.gnome.desktop.wm.keybindings');
    this.mutterKeybindingsSettings = this.getSettings('org.gnome.mutter.keybindings');
    this.gnomeKeybindingsSettings.set_strv('maximize', []);
    this.gnomeKeybindingsSettings.set_strv('unmaximize', []);
    this.mutterKeybindingsSettings.set_strv('toggle-tiled-left', []);
    this.mutterKeybindingsSettings.set_strv('toggle-tiled-right', []);
    this.keybindings = new Keybindings(this.getSettings());
    this.keybindings.add('move-window-right', this.handleMove(this.moveWindowRight.bind(this)));
    this.keybindings.add('move-window-left', this.handleMove(this.moveWindowLeft.bind(this)));
    this.keybindings.add('move-window-up', this.handleMove(this.moveWindowUp.bind(this)));
    this.keybindings.add('move-window-down', this.handleMove(this.moveWindowDown.bind(this)));
  }

  disable() {
    this.keybindings?.destroy();
    this.keybindings = null;
    this.tile?.destroy();
    this.tile = null;
    this.gnomeKeybindingsSettings?.reset('maximize');
    this.gnomeKeybindingsSettings?.reset('unmaximize');
    this.gnomeKeybindingsSettings = null;
    this.mutterKeybindingsSettings?.reset('toggle-tiled-left');
    this.mutterKeybindingsSettings?.reset('toggle-tiled-right');
    this.mutterKeybindingsSettings = null;
  }
}
