import * as Main from 'resource:///org/gnome/shell/ui/main.js';
import GLib from 'gi://GLib';

export default class Tile {
  window;
  screen;
  timeouts = new Set();
  gapSize;

  constructor(settings) {
    this.window = global.display.get_focus_window();
    const monitorIndex = this.window.get_monitor();
    this.screen = Main.layoutManager.getWorkAreaForMonitor(monitorIndex);
    this.gapSize = settings.get_int('gap-size');
    this.screen.x += this.gapSize;
    this.screen.y += this.gapSize;
    this.screen.width -= this.gapSize * 2;
    this.screen.height -= this.gapSize * 2;
  }

  get position() {
    const bounds = this.window.get_frame_rect();
    const top = bounds.y <= this.screen.y;
    const bottom = (bounds.y + bounds.height) >= (this.screen.y + this.screen.height);
    const left = bounds.x <= this.screen.x;
    const right = (bounds.x + bounds.width) >= (this.screen.x + this.screen.width);
    if (top && !bottom && left && right) {
      return 'top';
    }
    if (!top && bottom && left && right) {
      return 'bottom';
    }
    if (top && bottom && left && !right) {
      return 'left';
    }
    if (top && bottom && !left && right) {
      return 'right';
    }
    if (top && !bottom && left && !right) {
      return 'top-left';
    }
    if (top && !bottom && !left && right) {
      return 'top-right';
    }
    if (!top && bottom && left && !right) {
      return 'bottom-left';
    }
    if (!top && bottom && !left && right) {
      return 'bottom-right';
    }
    if (top && bottom && left && right) {
      return 'maximized';
    }
    return 'center';
  }

  doMove(position) {
    const halfGap = this.gapSize / 2;
    if (position === 'maximized') {
      return this.window.move_resize_frame(true, this.screen.x, this.screen.y, this.screen.width, this.screen.height);
    }
    if (position === 'top') {
      return this.window.move_resize_frame(true, this.screen.x, this.screen.y, this.screen.width, this.screen.height / 2 - halfGap);
    }
    if (position === 'bottom') {
      return this.window.move_resize_frame(true, this.screen.x, this.screen.y + (this.screen.height / 2) + halfGap, this.screen.width, this.screen.height / 2 - halfGap);
    }
    if (position === 'left') {
      return this.window.move_resize_frame(true, this.screen.x, this.screen.y, this.screen.width / 2 - halfGap, this.screen.height);
    }
    if (position === 'right') {
      return this.window.move_resize_frame(true, this.screen.x + (this.screen.width / 2) + halfGap, this.screen.y, this.screen.width / 2 - halfGap, this.screen.height);
    }
    if (position === 'top-left') {
      return this.window.move_resize_frame(true, this.screen.x, this.screen.y, this.screen.width / 2 - halfGap, this.screen.height / 2 - halfGap);
    }
    if (position === 'top-right') {
      return this.window.move_resize_frame(true, this.screen.x + (this.screen.width / 2) + halfGap, this.screen.y, this.screen.width / 2 - halfGap, this.screen.height / 2 - halfGap);
    }
    if (position === 'bottom-left') {
      return this.window.move_resize_frame(true, this.screen.x, this.screen.y + (this.screen.height / 2) + halfGap, this.screen.width / 2 - halfGap, this.screen.height / 2 - halfGap);
    }
    if (position === 'bottom-right') {
      return this.window.move_resize_frame(true, this.screen.x + this.screen.width / 2 + halfGap, this.screen.y + this.screen.height / 2 + halfGap, this.screen.width / 2 - halfGap, this.screen.height / 2 - halfGap);
    }
  }

  move(position) {
    if (this.window.get_maximize_flags() > 0) {
      this.window.unmaximize();
      const timeoutId = GLib.timeout_add(GLib.PRIORITY_DEFAULT, 20, () => {
        this.doMove(position);
        if (this.position === position) {
          this.timeouts.delete(timeoutId);
          return GLib.SOURCE_REMOVE;
        }
        return GLib.SOURCE_CONTINUE;
      });
      this.timeouts.add(timeoutId);
      return;
    }
    return this.doMove(position);
  }

  destroy() {
    for (const timeoutId of this.timeouts) {
      GLib.source_remove(timeoutId);
    }
    this.timeouts.clear();
  }
}
