# Ping Bot - GNOME Shell Extension

A lightweight GNOME Shell extension that monitors the availability of your websites and services by periodically pinging URLs and displaying their status with visual indicators.
Mainly this is made for personal needs, but thought this could be useful for others as well.

**No external services required.** Unlike Uptime Kuma or cloud-based monitoring solutions, Ping Bot runs entirely on your local machine. No API keys, no accounts, no servers to maintain - just install and start monitoring.

![Ping Bot Screenshot](git-images/ping-bot.png)

## Why Ping Bot?

**Simple Local Monitoring** - Pings run directly from your machine, no external infrastructure needed:
- No external services or API keys required
- No account registration or authentication
- No separate servers or Docker containers to run
- No cloud services involved - your URLs stay private
- Works for local network monitoring

**Comparison to Other Solutions:**
- **vs Uptime Kuma**: No need to self-host a server or run Docker
- **vs Cloud Services**: No accounts, subscriptions, or data leaving your machine
- **vs Kuma Shell Extension**: No external Uptime Kuma instance required

## Features

- **Visual Status Indicators**: Color-coded emoji indicators (green/yellow/red) show the health of your monitored URLs
- **Panel Menu**: Click the panel icon to see all monitored URLs with their current status
- **Automatic Monitoring**: Configurable ping intervals
- **Network Awareness**: Automatically detects network connectivity before attempting to ping URLs
- **Per-URL Status**: Each URL displays its own status icon in the settings panel and dropdown menu
- **Real-time Updates**: Status icons update live in the preferences window and panel menu
- **Failure Notifications**: Receive GNOME notifications when URLs fail (maximum once per hour)
- **Click to Open**: Click URLs in the panel dropdown to open them in your default browser

## Installation

### Enable it trough GNOME Extensions website
or

### Manual/local install - Quick Start (3 steps)

1. **Install the extension:**
   ```bash
   git clone https://github.com/lauzis/pingbot.git ~/.local/share/gnome-shell/extensions/pingbot@gudlenieks.lv
   ```

2. **Compile the settings schema:**
   ```bash
   cd ~/.local/share/gnome-shell/extensions/pingbot@gudlenieks.lv/schemas
   glib-compile-schemas .
   ```

3. **Enable the extension:**
   - Press `Alt+F2`, type `r`, press Enter (X11) OR log out and back in (Wayland)
   - Enable: `gnome-extensions enable pingbot@gudlenieks.lv`

### Getting Started

1. **Add URLs**: Click robot icon → Settings → Enter URLs to monitor
2. **Configure**: Set ping interval
3. **Monitor**: Status updates automatically - click URLs in panel to open them

That's it! No accounts, no API keys, no external services needed.

## Usage

### Adding URLs to Monitor

1. Click on the robot icon in the top panel
2. Select Settings from the dropdown menu
3. In the "URLs to Monitor" section:
   - Enter a URL (e.g., `https://example.com`)
   - Click Add URL or press Enter
4. The URL will appear in the list with a status icon

### Status Indicators

The extension uses three colored circles to indicate status:

- Green circle: URL is accessible (HTTP 200 OK)
- Yellow circle: Status unknown or no network connection
- Red circle: URL is not accessible or returned an error

### Panel Icon Logic

The main panel icon shows a robot emoji followed by a colored status circle:

- All URLs green: Panel shows robot + green circle
- All URLs yellow: Panel shows robot + yellow circle
- Any URL red: Panel shows robot + red circle (even if others are green)

### Panel Dropdown Menu

Click the panel icon to see:
- List of all monitored URLs with their current status
- Click any URL to open it in your default browser
- Settings button to access configuration

### Configuring Ping Interval

1. Open Settings (click robot icon → Settings)
2. Adjust the "Ping Interval" value (1-1440 minutes)
3. The extension will automatically use the new interval

### Deleting URLs

Click the trash icon next to any URL in the settings list to remove it from monitoring.

## How It Works

1. **Network Check**: Before pinging URLs, the extension checks for internet connectivity
2. **Periodic Pinging**: At the configured interval, the extension sends HTTP GET requests to each URL
3. **Status Update**: Based on the response (or lack thereof), each URL's status is updated
4. **Visual Feedback**: Icons in both the panel and settings window update to reflect current status
5. **Failure Notifications**: When a URL transitions from working to failed, a GNOME notification is sent (throttled to once per hour)
6. **Persistence**: All statuses are saved to GSettings and survive extension reloads

## Technical Details

### Architecture

- **Extension Type**: GNOME Shell Panel Extension
- **Language**: JavaScript (GJS)
- **Code Organization**: Modular architecture with `lib/` directory (7 focused modules)
- **Dependencies**: 
  - GNOME Shell 45/46
  - GTK4 (Adwaita)
  - libsoup (for HTTP requests)
  - GSettings (for configuration storage)
  - Gio.NetworkMonitor (for network connectivity checks)
  - 
### Settings Schema

The extension uses GSettings to store:

- `ping-interval` (integer): Time between pings in minutes
- `ping-urls` (array of strings): List of URLs to monitor
- `url-statuses` (JSON string): Cached status for each URL

## Development

### Testing in Nested Shell

For development and testing without affecting your main session:

```bash
MUTTER_DEBUG_DUMMY_MODE_SPECS=1920x1080 dbus-run-session -- gnome-shell --nested --wayland
```

### Viewing Logs

Production logs:
```bash
journalctl -f -o cat /usr/bin/gnome-shell | grep "\[pingbot\]"
```

Debug mode (verbose):
```bash
G_MESSAGES_DEBUG=pingbot gnome-shell --replace
journalctl -f -o cat /usr/bin/gnome-shell | grep "\[pingbot\]"
```

### Debugging

Enable the extension and check for errors:

```bash
gnome-extensions info pingbot@gudlenieks.lv
```

## Known Limitations

- URLs must be accessible via HTTP/HTTPS GET requests
- Only HTTP and HTTPS protocols are supported (FTP, file://, etc. are rejected)
- Minimum ping interval is 1 minute (to avoid excessive network traffic)
- Network check uses GNOME's native NetworkMonitor API
- Notifications are throttled to once per hour to avoid spam

## Changelog

### Version 1.0.1 (November 13, 2025)

**Improvements:**
- Replaced Mozilla portal network check with native GNOME `Gio.NetworkMonitor` API
  - More reliable network connectivity detection
  - No external HTTP requests for connectivity checks
  - Uses GNOME's built-in network monitoring system
- Added extension icon (128x128 PNG) generated from favicon
- Added `release.sh` script for automated release packaging
  - Excludes development files (.git, .idea, git-images, etc.)
  - Creates clean zip ready for distribution
- Refactored code into modular architecture
  - Created `lib/` directory for helper modules
  - Split extension.js into 6 focused modules:
    - `logger.js` - Centralized logging with debug mode
    - `statusManager.js` - Status persistence
    - `urlPinger.js` - HTTP requests
    - `pingScheduler.js` - Periodic scheduling
    - `panelIndicator.js` - Panel UI & menu
    - `notificationManager.js` - Notifications
  - Main class reduced by 76% (317 to 80 lines)
  - Better code organization and maintainability
- Improved resource management
  - Proper timeout cleanup before creating new ones
  - Session tracking with `session.abort()` on disable
  - Prevents memory leaks from pending HTTP requests
- Professional logging system
  - Silent in production (only lifecycle + errors)
  - Verbose debug mode: `G_MESSAGES_DEBUG=pingbot`
  - Uses GNOME's native logging functions
  - Respects privacy (no URL logging by default)

### Version 1.0 (November 2025)

Initial release with the following features:

- Panel icon with robot emoji and colored status indicator
- Click panel icon to see dropdown menu with all monitored URLs
- Click URLs in dropdown to open in default browser
- Settings page with URL management (add/delete)
- Real-time status updates with colored emoji indicators (green/yellow/red)
- Configurable ping interval (1-1440 minutes)
- Network connectivity detection before pinging
- URL validation (only HTTP/HTTPS allowed)
- Visual error feedback for invalid URLs
- Persistent status storage across sessions
- GNOME notifications for failures (once per hour)
- Support for GNOME Shell 45/46

## Compatibility

- **GNOME Shell**: 45, 46
- **Tested on**: Ubuntu 24.04, Fedora 40

## License

MIT License - see [LICENSE](LICENSE) file for details.

## Contributing

Contributions, bug reports, and feature requests are welcome!

## Author

Aivars Lauzis

Code mostly generated by GitHub Copilot CLI.

---

**Version**: 1.0.1  
**Last Updated**: November 13, 2025
