import { Extension } from 'resource:///org/gnome/shell/extensions/extension.js';
import * as Main from 'resource:///org/gnome/shell/ui/main.js';
import * as Bindings from './bindings.js';
const PRIVACY_INDICATORS_CLASS = 'privacy-indicators-accent-color';
const SCREEN_SHARING_INDICATOR_CLASS = 'screen-sharing-indicator-accent-color';
const SCREEN_RECORDING_INDICATOR_CLASS = 'screen-recording-indicator-accent-color';
const BLUR_CLASS = 'screen-sharing-recording-indicators-blur';
const NEUTRAL_COLOR_CLASS = 'neutral-color';
export default class PrivacyIndicatorsAccentColor extends Extension {
    _settings;
    _onPrivacyIndicatorsChangedID;
    _onScreenSharingIndicatorChangedID;
    _onScreenRecordingIndicatorChangedID;
    _onBlurChangedID;
    _onNeutralColorChangedID;
    enable() {
        this._settings = this.getSettings();
        // load initial values
        this._onPrivacyIndicatorsChanged();
        this._onScreenSharingIndicatorChanged();
        this._onScreenRecordingIndicatorChanged();
        this._onBlurChanged();
        this._onNeutralColorChanged();
        // register listeners
        this._onPrivacyIndicatorsChangedID = this._settings.connect('changed::' + Bindings.PRIVACY_INDICATORS, this._onPrivacyIndicatorsChanged.bind(this));
        this._onScreenSharingIndicatorChangedID = this._settings.connect('changed::' + Bindings.SCREEN_SHARING_INDICATOR, this._onScreenSharingIndicatorChanged.bind(this));
        this._onScreenRecordingIndicatorChangedID = this._settings.connect('changed::' + Bindings.SCREEN_RECORDING_INDICATOR, this._onScreenRecordingIndicatorChanged.bind(this));
        this._onBlurChangedID = this._settings.connect('changed::' + Bindings.BLUR, this._onBlurChanged.bind(this));
        this._onNeutralColorChangedID = this._settings.connect('changed::' + Bindings.NEUTRAL_COLOR, this._onNeutralColorChanged.bind(this));
    }
    disable() {
        // unregister listeners
        if (this._onPrivacyIndicatorsChangedID) {
            this._settings?.disconnect(this._onPrivacyIndicatorsChangedID);
            this._onPrivacyIndicatorsChangedID = undefined;
        }
        if (this._onScreenSharingIndicatorChangedID) {
            this._settings?.disconnect(this._onScreenSharingIndicatorChangedID);
            this._onScreenSharingIndicatorChangedID = undefined;
        }
        if (this._onScreenRecordingIndicatorChangedID) {
            this._settings?.disconnect(this._onScreenRecordingIndicatorChangedID);
            this._onScreenRecordingIndicatorChangedID = undefined;
        }
        if (this._onBlurChangedID) {
            this._settings?.disconnect(this._onBlurChangedID);
            this._onBlurChangedID = undefined;
        }
        if (this._onNeutralColorChangedID) {
            this._settings?.disconnect(this._onNeutralColorChangedID);
            this._onNeutralColorChangedID = undefined;
        }
        // remove classes
        this._updateClass(false, PRIVACY_INDICATORS_CLASS);
        this._updateClass(false, SCREEN_SHARING_INDICATOR_CLASS);
        this._updateClass(false, SCREEN_RECORDING_INDICATOR_CLASS);
        this._updateClass(false, BLUR_CLASS);
        this._updateClass(false, NEUTRAL_COLOR_CLASS);
        this._settings = undefined;
    }
    // helper function to add or remove a class
    _updateClass(add, className) {
        if (add) {
            Main.layoutManager.uiGroup.add_style_class_name(className);
            return;
        }
        Main.layoutManager.uiGroup.remove_style_class_name(className);
    }
    _onPrivacyIndicatorsChanged() {
        this._updateClass(this._settings?.get_boolean(Bindings.PRIVACY_INDICATORS), PRIVACY_INDICATORS_CLASS);
    }
    _onScreenSharingIndicatorChanged() {
        this._updateClass(this._settings?.get_boolean(Bindings.SCREEN_SHARING_INDICATOR), SCREEN_SHARING_INDICATOR_CLASS);
    }
    _onScreenRecordingIndicatorChanged() {
        this._updateClass(this._settings?.get_boolean(Bindings.SCREEN_RECORDING_INDICATOR), SCREEN_RECORDING_INDICATOR_CLASS);
    }
    _onBlurChanged() {
        this._updateClass(this._settings?.get_boolean(Bindings.BLUR), BLUR_CLASS);
    }
    _onNeutralColorChanged() {
        this._updateClass(this._settings?.get_boolean(Bindings.NEUTRAL_COLOR), NEUTRAL_COLOR_CLASS);
    }
}
