import Adw from 'gi://Adw';
import Gio from 'gi://Gio';
import { ExtensionPreferences, gettext as _, } from 'resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js';
import * as Bindings from './bindings.js';
export default class PrivacyIndicatorsAccentColorPreferences extends ExtensionPreferences {
    _settings;
    fillPreferencesWindow(window) {
        const page = new Adw.PreferencesPage();
        window.add(page);
        const group = new Adw.PreferencesGroup({
            title: _('Appearance'),
        });
        page.add(group);
        const privacyIndicatorsRow = new Adw.SwitchRow({
            title: _('Privacy Indicators'),
            subtitle: _('Recolor the privacy indicators'),
        });
        group.add(privacyIndicatorsRow);
        const screenSharingIndicatorRow = new Adw.SwitchRow({
            title: _('Screen Sharing Indicator'),
            subtitle: _('Recolor the screen sharing indicator'),
        });
        group.add(screenSharingIndicatorRow);
        const screenRecordingIndicatorRow = new Adw.SwitchRow({
            title: _('Screen Recording Indicator'),
            subtitle: _('Recolor the screen recording indicator'),
        });
        group.add(screenRecordingIndicatorRow);
        const blurRow = new Adw.SwitchRow({
            title: _('Blur'),
            subtitle: _('Apply blur to the screen sharing and recording indicators; this setting only works if the indicators are recolored'),
        });
        group.add(blurRow);
        const neutralColorRow = new Adw.SwitchRow({
            title: _('Neutral Color'),
            subtitle: _('Use a neutral color instead of the accent color'),
        });
        group.add(neutralColorRow);
        this._settings = this.getSettings();
        this._settings.bind(Bindings.PRIVACY_INDICATORS, privacyIndicatorsRow, 'active', Gio.SettingsBindFlags.DEFAULT);
        this._settings.bind(Bindings.SCREEN_SHARING_INDICATOR, screenSharingIndicatorRow, 'active', Gio.SettingsBindFlags.DEFAULT);
        this._settings.bind(Bindings.SCREEN_RECORDING_INDICATOR, screenRecordingIndicatorRow, 'active', Gio.SettingsBindFlags.DEFAULT);
        this._settings.bind(Bindings.BLUR, blurRow, 'active', Gio.SettingsBindFlags.DEFAULT);
        this._settings.bind(Bindings.NEUTRAL_COLOR, neutralColorRow, 'active', Gio.SettingsBindFlags.DEFAULT);
        return Promise.resolve();
    }
}
