Introduction
------------

This GNOME Shell Extension aims to display information to center box. Using DBUS protocol, any application can add or remove text and icons in the upper bar, right after date & clock.


Installation
------------

Install it from https://extensions.gnome.org/extension/2826/generic-monitor/

OR

Create a symbolic link from your _.local_ directory and enable extension

```bash
ln -s $PWD/generic-monitor@gnome-shell-extensions/ ~/.local/share/gnome-shell/extensions/

gnome-extensions enable generic-monitor@gnome-shell-extensions
```

Restart GNOME


DBUS protocol
-------------

All functions read JSON formatted parameters

```js
  notify():
  {
      "group": "groupname",
      "items": [
          {
	      "name"  : "",
	      "box"   : ["left"|"center"|"right"],  // Optional : center by default
	      "text"  : <text_object>,  // Optional
	      "icon"  : <icon_object>,  // Optional
	      "popup" : <popup_object>, // Optional
	      <signals_description>,    // Optional
          }, ...
      ]
      }
  }

  deleteItems():
  {
     "items": ["<itemName>@<groupName>", ...]
  }

  deleteGroups():
  {
     "groups": ["<groupName>", ...]
  }

  openPopup():
  {
     "item": "<itemName>@<groupName>"
  }

  closePopup():
  {
     "item": "<itemName>@<groupName>"
  }

  togglePopup():
  {
     "item": "<itemName>@<groupName>"
  }
```


DBUS object
===========

<text_object> is defined as:
```js
  "text" : {
    "name"  : "" // Optional, used with popup nested element
    <signals_description>,    // Optional, used with popup nested element
    "text"  : "Text to be displayed",
    "style" : "CSS style to be applied", // Optional
  }
```

<icon_object> is defined as:
```js
  "icon" : {
    "path"  : "Icon path",
    "style" : "CSS style to be applied", // Optional
  }
```

<picture_object> is defined as:
```js
  "picture" : {
    "name"  : "" // Optional, used with popup nested element
    <signals_description>,    // Optional, used with popup nested element
    "path"   : "Icon path",
    "width"  : XXX, // Optional : Force width in pixels, can be -1 for defaut value
    "height" : XXX, // Optional : Force height in pixels, can be -1 for defaut value
  }
```

<popup_object> is defined as:
```js
  "popup" : {
     "items": [<text_objects> and/or <picture_objects>]
  }
```

Signals description
===================

Signals can be :

```js
  "on-click"          : ["signal"|"delete"|"open-popup"|"close-popup"|"toggle-popup"]
  "on-dblclick"       : ["signal"|"delete"|"open-popup"|"close-popup"|"toggle-popup"]
  "on-rightclick"     : ["signal"|"delete"|"open-popup"|"close-popup"|"toggle-popup"]
  "on-rightdblclick"  : ["signal"|"delete"|"open-popup"|"close-popup"|"toggle-popup"]
  "on-enter"          : ["signal"|"delete"|"open-popup"|"close-popup"|"toggle-popup"]
  "on-leave"          : ["signal"|"delete"|"open-popup"|"close-popup"|"toggle-popup"]
  "on-scroll"         : ["signal"|"delete"|"open-popup"|"close-popup"|"toggle-popup"]
```

Targets :

  * signal            : Emit a signal to desktop application
  * delete            : Delete item
  * open-popup        : Open the popup if there is one
  * close-popup       : Close the popup if there is one
  * toggle-popup      : Toggle (open/close) the popup if there is one


Signal names emit when action "signal" is specified:

  * onClick
  * onDblClick
  * onRightClick
  * onRightDblClick
  * onEnter
  * onLeave
  * onScrollUp
  * onScrollDown

Each signal is sent with one parameter: "<itemName>@<groupName>"
For popup nested elements, parameter is "<nestedName>@<itemName>@<groupName>"
where nestedName can be empty if not defined by user

Other signals are available when extension is activated/deactivated:

  * onActivate
  * onDeactivate


Example
-------

You can test it with command line:

```bash
# Create new group and add items
gdbus call --session --dest org.gnome.Shell --object-path /com/soutade/GenericMonitor --method com.soutade.GenericMonitor.notify '{"group":"new","items":[{"name":"first","on-click":"toggle-popup","text":{"text":"Hello","style":"color:green"},"popup":{"items":[{"picture":{"path":"/tmp/cat.jpg"}}]}}]}'

# Delete group
gdbus call --session --dest org.gnome.Shell --object-path /com/soutade/GenericMonitor --method com.soutade.GenericMonitor.deleteGroups '{"groups":["new"]}'
```

Python examples are available @ https://indefero.soutade.fr/p/genericmonitor/source/tree/master/examples


Development
-----------

After doing code update, you can test it within a nested window. In other cases you have to restart GNOME.

```bash
dbus-run-session -- gnome-shell --nested [--wayland]
```

To see log & errors:

```bash
journalctl /usr/bin/gnome-shell
```

Licence
-------

GNU GPL 3