# SoundBar — GNOME Shell Audio Visualizer

SoundBar is a small GNOME Shell extension that shows an audio visualizer in the panel using `cava` (Console-based Audio Visualizer). It spawns a `cava` process which outputs raw audio frames to stdout and the extension reads those frames to render the bars.

**What it does**
- Spawns `cava` with a temporary config that sets the input to PulseAudio and output to `raw` (stdout).
- Reads the raw audio frames from `cava` and renders them as a set of bars in the top panel.
- Dynamically regenerates a temp config file with the user `sensitivity` preference.

Note: At runtime the extension creates a temporary config file at `/tmp/soundbar-cava-config` 

Requirements
- GNOME Shell (extension system)
- `gjs` and GNOME Shell JS libraries (provided by GNOME Shell)
- `cava` installed and available on `PATH` (e.g. `apt install cava` on Debian/Ubuntu)
- PulseAudio or PipeWire with PulseAudio compatibility (so `cava` can read from Pulse)

Installation
- Install `cava`:

```bash
sudo apt update
sudo apt install cava    # Debian/Ubuntu
# or your distro's package manager
```

- Install the extension (copy this folder to `~/.local/share/gnome-shell/extensions/soundbar@karthickk.gitlab.com/`).
- Reload GNOME Shell or re-enable the extension:

```bash
# X11: press Alt+F2, type r and press Enter
# Or via gnome-extensions command:
gnome-extensions disable soundbar@karthickk.gitlab.com
gnome-extensions enable soundbar@karthickk.gitlab.com
```

Runtime behavior and safety
- The extension writes `/tmp/soundbar-cava-config` and launches `cava -p /tmp/soundbar-cava-config`.
- The extension watches the child process and reaps it properly; when the extension is disabled it attempts to terminate the `cava` process and close the OS handle.

License / Attribution
- This project uses `cava` (https://github.com/karlstav/cava) for audio analysis; respect `cava`'s license when distributing.
