import Adw from 'gi://Adw';
import Gio from 'gi://Gio';
import Gtk from 'gi://Gtk';
import {ExtensionPreferences} from 'resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js';

export default class BoatmanPreferences extends ExtensionPreferences {
    fillPreferencesWindow(window) {
        const settings = this.getSettings();

        window.set_default_size(600, 650);

        const page = new Adw.PreferencesPage();
        window.add(page);

        // General Settings Group
        const generalGroup = new Adw.PreferencesGroup({
            title: 'General Settings',
        });
        page.add(generalGroup);

        // Refresh interval row
        const intervalRow = new Adw.ActionRow({
            title: 'Refresh interval (seconds)',
            subtitle: 'How often to poll the WinBoat container status. Range: 10-300 seconds (5 minutes).',
        });

        const intervalAdjustment = new Gtk.Adjustment({
            lower: 10,
            upper: 300,
            step_increment: 10,
            page_increment: 30,
            value: settings.get_int('refresh-interval'),
        });
        const intervalSpin = new Gtk.SpinButton({
            adjustment: intervalAdjustment,
            numeric: true,
            valign: Gtk.Align.CENTER,
        });
        settings.bind('refresh-interval', intervalSpin, 'value', Gio.SettingsBindFlags.DEFAULT);
        intervalRow.add_suffix(intervalSpin);
        intervalRow.activatable_widget = intervalSpin;
        generalGroup.add(intervalRow);

        // Enable notifications row
        const notifyRow = new Adw.ActionRow({
            title: 'Enable notifications',
            subtitle: 'Show desktop notifications when WinBoat starts, stops, or errors.',
        });
        const notifySwitch = new Gtk.Switch({
            active: settings.get_boolean('enable-notifications'),
            valign: Gtk.Align.CENTER,
        });
        settings.bind('enable-notifications', notifySwitch, 'active', Gio.SettingsBindFlags.DEFAULT);
        notifyRow.add_suffix(notifySwitch);
        notifyRow.activatable_widget = notifySwitch;
        generalGroup.add(notifyRow);

        // Runtime mode row
        const runtimeRow = new Adw.ActionRow({
            title: 'Container runtime',
            subtitle: 'Choose which container runtime to use for WinBoat.',
        });

        const runtimeOptions = [
            ['auto', 'Auto (detect Docker/Podman)'],
            ['docker', 'Docker'],
            ['podman', 'Podman'],
        ];

        const runtimeLabels = runtimeOptions.map(opt => opt[1]);
        const runtimeList = Gtk.StringList.new(runtimeLabels);

        const runtimeDropDown = new Gtk.DropDown({
            model: runtimeList,
            valign: Gtk.Align.CENTER,
        });

        const currentRuntime = settings.get_string('runtime-mode');
        let activeIndex = runtimeOptions.findIndex(opt => opt[0] === currentRuntime);
        if (activeIndex < 0)
            activeIndex = 0;
        runtimeDropDown.set_selected(activeIndex);

        runtimeDropDown.connect('notify::selected', widget => {
            const idx = widget.get_selected();
            if (idx >= 0 && idx < runtimeOptions.length)
                settings.set_string('runtime-mode', runtimeOptions[idx][0]);
        });

        runtimeRow.add_suffix(runtimeDropDown);
        runtimeRow.activatable_widget = runtimeDropDown;
        generalGroup.add(runtimeRow);

        // Display Settings Group
        const displayGroup = new Adw.PreferencesGroup({
            title: 'Display Settings',
        });
        page.add(displayGroup);

        // Show uptime row
        const uptimeRow = new Adw.ActionRow({
            title: 'Show uptime',
            subtitle: 'Display container uptime in the menu.',
        });
        const uptimeSwitch = new Gtk.Switch({
            active: settings.get_boolean('show-uptime'),
            valign: Gtk.Align.CENTER,
        });
        settings.bind('show-uptime', uptimeSwitch, 'active', Gio.SettingsBindFlags.DEFAULT);
        uptimeRow.add_suffix(uptimeSwitch);
        uptimeRow.activatable_widget = uptimeSwitch;
        displayGroup.add(uptimeRow);

        // Show stats row
        const statsRow = new Adw.ActionRow({
            title: 'Show statistics',
            subtitle: 'Display CPU, Memory, and Ports statistics in the menu.',
        });
        const statsSwitch = new Gtk.Switch({
            active: settings.get_boolean('show-stats'),
            valign: Gtk.Align.CENTER,
        });
        settings.bind('show-stats', statsSwitch, 'active', Gio.SettingsBindFlags.DEFAULT);
        statsRow.add_suffix(statsSwitch);
        statsRow.activatable_widget = statsSwitch;
        displayGroup.add(statsRow);

        // Compact mode row
        const compactRow = new Adw.ActionRow({
            title: 'Compact mode',
            subtitle: 'Show minimal text in the menu for cleaner appearance.',
        });
        const compactSwitch = new Gtk.Switch({
            active: settings.get_boolean('compact-mode'),
            valign: Gtk.Align.CENTER,
        });
        settings.bind('compact-mode', compactSwitch, 'active', Gio.SettingsBindFlags.DEFAULT);
        compactRow.add_suffix(compactSwitch);
        compactRow.activatable_widget = compactSwitch;
        displayGroup.add(compactRow);

        // Advanced Settings Group
        const advancedGroup = new Adw.PreferencesGroup({
            title: 'Advanced Settings',
        });
        page.add(advancedGroup);

        // Development warning row
        const warningRow = new Adw.ActionRow({
            title: '⚠️ Development Version',
            subtitle: 'WinBoat is under heavy development (beta). Changes may affect extension functionality. This is an unofficial hobby project - not affiliated with the WinBoat development team.',
        });
        warningRow.add_suffix(new Gtk.Label({
            label: '🚧',
            valign: Gtk.Align.CENTER,
        }));
        advancedGroup.add(warningRow);

        // Debug mode row
        const debugRow = new Adw.ActionRow({
            title: 'Debug mode',
            subtitle: 'Enable detailed logging for troubleshooting (check journalctl).',
        });
        const debugSwitch = new Gtk.Switch({
            active: settings.get_boolean('debug-mode'),
            valign: Gtk.Align.CENTER,
        });
        settings.bind('debug-mode', debugSwitch, 'active', Gio.SettingsBindFlags.DEFAULT);
        debugRow.add_suffix(debugSwitch);
        debugRow.activatable_widget = debugSwitch;
        advancedGroup.add(debugRow);

        window.set_default_size(600, 650);
    }
}
