uniform sampler2D tex;
uniform float param1 = 1.0;
uniform float param2 = 0.0;
uniform float param3 = 0.5;
uniform float param4 = 0.35;
uniform float time;

// RGB (0..1) -> HSV (H:0..1, S:0..1, V:0..1)
vec3 rgb2hsv(vec3 c) {
    float cmax = max(max(c.r, c.g), c.b);
    float cmin = min(min(c.r, c.g), c.b);
    float delta = cmax - cmin;

    float h = 0.0;
    if (delta > 0.00001) {
        if (cmax == c.r) {
            h = mod((c.g - c.b) / delta, 6.0);
        } else if (cmax == c.g) {
            h = (c.b - c.r) / delta + 2.0;
        } else { // cmax == c.b
            h = (c.r - c.g) / delta + 4.0;
        }
        h /= 6.0; // normalize to 0..1
        if (h < 0.0) h += 1.0;
    }

    float s = (cmax <= 0.0) ? 0.0 : delta / cmax;
    float v = cmax;
    return vec3(h, s, v);
}

// HSV (H:0..1, S:0..1, V:0..1) -> RGB (0..1)
vec3 hsv2rgb(vec3 c) {
    float h = c.x * 6.0;
    float s = c.y;
    float v = c.z;

    float i = floor(h);
    float f = h - i;
    float p = v * (1.0 - s);
    float q = v * (1.0 - s * f);
    float t = v * (1.0 - s * (1.0 - f));

    if (i == 0.0) return vec3(v, t, p);
    else if (i == 1.0) return vec3(q, v, p);
    else if (i == 2.0) return vec3(p, v, t);
    else if (i == 3.0) return vec3(p, q, v);
    else if (i == 4.0) return vec3(t, p, v);
    else return vec3(v, p, q);
}

float protect_eye(float hue)
{
    const float target = 0.666666666;  // blue

    float strength = param1;    // 0..1   → how strong to push
    float radius   = (param2 * 0.125) + 0.125;    // Range : 0.125 - 0.25, meaning at least %12.5 of the hues will be influenced and max %25 from median point blue hue.

    // Signed circular distance hue → target
    float d = hue - target;
    if (d > 0.5) d -= 1.0;
    if (d < -0.5) d += 1.0;

    // Normalize distance into 0..1 within the radius
    float nd = abs(d) / radius;

    // falloff: only affect within radius
    float falloff = 1.0 - smoothstep(0.0, 1.0, nd);

    // remap param3 to exponent range
    float minExp = 0.75;  // harshest
    float maxExp = 1.3;  // softest
    float exponent = mix(maxExp, minExp, param3);  // 0 -> soft, 1 -> hard
    
    // shift direction = away from the target
    float shift = sign(d) * falloff * strength * radius * pow(nd, exponent);

    float newHue = hue + shift;

    return fract(newHue);
}

vec3 hue_fix(vec3 color) 
{
    // Hue Shifting
    vec3 hsv = rgb2hsv(color);
    
    // Apply HueShift before LS Cutter, so LS Cutter syncs with hue shift, so dimming won't be broken.
    hsv.x = protect_eye(hsv.x);
    
    // Cache Distance
    float d = hsv.x - 0.666666666;
    if (d > 0.5) d -= 1.0;
    if (d < -0.5) d += 1.0;
    
    float radius = (param2 * 0.125) + 0.125;
    float nd = clamp(abs(d) / radius, 0.0, 1.0);  // normalized distance from blue (0=center, 1=edge)
    float falloff = 1.0 - smoothstep(0.0, 1.0, nd); // 1=center, 0=edge

    float maxInf = (param4 * 0.4) + 0.1; // Slider control 0.1-0.5
    float influence = falloff * param1 * maxInf * hsv.y * hsv.z; // scales with strength and max influence
   
    // Convert to RGB again
    vec3 rgb = hsv2rgb(hsv);
    rgb *= 1.0 - influence; // dims RGB proportionally

    return rgb;
}

void main() {
    vec2 uv = cogl_tex_coord_in[0].xy;
    vec3 color = texture2D(tex, uv).rgb;
    
    color = hue_fix(color);
    
    cogl_color_out = vec4(color, 1.0);
}
