// For GNOME Shell version before 45
const Me = imports.misc.extensionUtils.getCurrentExtension();
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
  if (decorator = decorators[i])
  result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp(target, key, result);
  return result;
};
var LayoutWidget = Me.imports.components.layout.LayoutWidget.LayoutWidget;
var registerGObjectClass = Me.imports.utils.gjs.registerGObjectClass;
var buildMarginOf = Me.imports.utils.ui.buildMarginOf;
var buildRectangle = Me.imports.utils.ui.buildRectangle;
var getScalingFactorOf = Me.imports.utils.ui.getScalingFactorOf;
var SnapAssistTileButton = Me.imports.components.snapassist.snapAssistTileButton.SnapAssistTileButton;
var LayoutTileButtons = class extends LayoutWidget {
  constructor(parent, layout, gapSize, height, width) {
    super({
      parent,
      layout,
      containerRect: buildRectangle(),
      innerGaps: buildMarginOf(gapSize),
      outerGaps: buildMarginOf(gapSize),
      styleClass: "window-menu-layout"
    });
    const [, scalingFactor] = getScalingFactorOf(this);
    this.relayout({
      containerRect: buildRectangle({
        x: 0,
        y: 0,
        width: width * scalingFactor,
        height: height * scalingFactor
      })
    });
    this._fixFloatingPointErrors();
  }
  buildTile(parent, rect, gaps, tile) {
    return new SnapAssistTileButton({ parent, rect, gaps, tile });
  }
  get buttons() {
    return this._previews;
  }
  _fixFloatingPointErrors() {
    const xMap = /* @__PURE__ */new Map();
    const yMap = /* @__PURE__ */new Map();
    this._previews.forEach((prev) => {
      const tile = prev.tile;
      const newX = xMap.get(tile.x);
      if (!newX) xMap.set(tile.x, prev.rect.x);
      const newY = yMap.get(tile.y);
      if (!newY) yMap.set(tile.y, prev.rect.y);
      if (newX || newY) {
        prev.open(
          false,
          buildRectangle({
            x: newX ?? prev.rect.x,
            y: newY ?? prev.rect.y,
            width: prev.rect.width,
            height: prev.rect.height
          })
        );
      }
      xMap.set(
        tile.x + tile.width,
        xMap.get(tile.x + tile.width) ?? prev.rect.x + prev.rect.width
      );
      yMap.set(
        tile.y + tile.height,
        yMap.get(tile.y + tile.height) ?? prev.rect.y + prev.rect.height
      );
    });
  }
};
LayoutTileButtons = __decorateClass([
registerGObjectClass],
LayoutTileButtons);