// For GNOME Shell version before 45
const Me = imports.misc.extensionUtils.getCurrentExtension();
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
  if (decorator = decorators[i])
  result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp(target, key, result);
  return result;
};
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
var windowMenu = imports.ui.windowMenu;
var PopupMenu = imports.ui.popupMenu;
var Main = imports.ui.main;
var GObject = Me.imports.gi.ext.GObject;
var St = Me.imports.gi.ext.St;
var Clutter = Me.imports.gi.ext.Clutter;
var Meta = Me.imports.gi.ext.Meta;
var GlobalState = Me.imports.utils.globalState.GlobalState;
var registerGObjectClass = Me.imports.utils.gjs.registerGObjectClass;
var Tile = Me.imports.components.layout.Tile.Tile;
var enableScalingFactorSupport = Me.imports.utils.ui.enableScalingFactorSupport;
var getMonitorScalingFactor = Me.imports.utils.ui.getMonitorScalingFactor;
var getWindows = Me.imports.utils.ui.getWindows;
var TileUtils = Me.imports.components.layout.TileUtils.TileUtils;
var LayoutTileButtons = Me.imports.components.window_menu.layoutTileButtons.LayoutTileButtons;
var buildMarginOf = Me.imports.utils.ui.buildMarginOf;
var LayoutIcon = Me.imports.components.window_menu.layoutIcon.LayoutIcon;
var _ = Me.imports.translations._;
var widgetOrientation = Me.imports.utils.gnomesupport.widgetOrientation;
var LAYOUT_ICON_WIDTH = 46;
var LAYOUT_ICON_HEIGHT = 32;
var INNER_GAPS = 2;
function buildMenuWithLayoutIcon(title, popupMenu, importantTiles, tiles, innerGaps) {
  popupMenu.add_child(
    new St.Label({
      text: title,
      yAlign: Clutter.ActorAlign.CENTER,
      xExpand: true
    })
  );
  const layoutIcon = new LayoutIcon(
    popupMenu,
    importantTiles,
    tiles,
    buildMarginOf(innerGaps),
    buildMarginOf(4),
    LAYOUT_ICON_WIDTH,
    LAYOUT_ICON_HEIGHT
  );
  layoutIcon.set_x_align(Clutter.ActorAlign.END);
}
var OverriddenWindowMenu = class extends GObject.Object {
  static get() {
    if (this._instance === null)
    this._instance = new OverriddenWindowMenu();
    return this._instance;
  }
  static enable() {
    if (this._enabled) return;
    const owm = this.get();
    OverriddenWindowMenu._old_buildMenu = windowMenu.WindowMenu.prototype._buildMenu;
    windowMenu.WindowMenu.prototype._buildMenu = owm.newBuildMenu;
    this._enabled = true;
  }
  static disable() {
    if (!this._enabled) return;
    windowMenu.WindowMenu.prototype._buildMenu = OverriddenWindowMenu._old_buildMenu;
    this._old_buildMenu = null;
    this._enabled = false;
  }
  static destroy() {
    this.disable();
    this._instance = null;
  }
  // the function will be treated as a method of class WindowMenu
  newBuildMenu(window) {
    const oldFunction = OverriddenWindowMenu._old_buildMenu?.bind(this);
    if (oldFunction) oldFunction(window);
    const layouts = GlobalState.get().layouts;
    if (layouts.length === 0) return;
    const workArea = Main.layoutManager.getWorkAreaForMonitor(
      window.get_monitor()
    );
    const tiledWindows = getWindows().map((otherWindow) => {
      return otherWindow && !otherWindow.minimized && otherWindow.assignedTile ? otherWindow : void 0;
    }).filter((w) => w !== void 0);
    const tiles = GlobalState.get().getSelectedLayoutOfMonitor(
      window.get_monitor(),
      global.workspaceManager.get_active_workspace_index()
    ).tiles;
    const vacantTiles = tiles.filter((t) => {
      const tileRect = TileUtils.apply_props(t, workArea);
      return !tiledWindows.find(
        (win) => tileRect.overlap(win.get_frame_rect())
      );
    });
    const enableScaling = window.get_monitor() === Main.layoutManager.primaryIndex;
    const scalingFactor = getMonitorScalingFactor(window.get_monitor());
    if (vacantTiles.length > 0) {
      vacantTiles.sort((a, b) => a.x - b.x);
      let bestTileIndex = 0;
      let bestDistance = Math.abs(
        0.5 - vacantTiles[bestTileIndex].x + vacantTiles[bestTileIndex].width / 2
      );
      for (let index = 1; index < vacantTiles.length; index++) {
        const distance = Math.abs(
          0.5 - (vacantTiles[index].x + vacantTiles[index].width / 2)
        );
        if (bestDistance > distance) {
          bestTileIndex = index;
          bestDistance = distance;
        }
      }
      this.addMenuItem(new PopupMenu.PopupSeparatorMenuItem());
      const vacantPopupMenu = new PopupMenu.PopupBaseMenuItem();
      this.addMenuItem(vacantPopupMenu);
      if (enableScaling)
      enableScalingFactorSupport(vacantPopupMenu, scalingFactor);
      buildMenuWithLayoutIcon(
        _("Move to best tile"),
        vacantPopupMenu,
        [vacantTiles[bestTileIndex]],
        tiles,
        INNER_GAPS
      );
      vacantPopupMenu.connect("activate", () => {
        OverriddenWindowMenu.get().emit(
          "tile-clicked",
          vacantTiles[bestTileIndex],
          window
        );
      });
    }
    if (vacantTiles.length > 1) {
      const vacantLeftPopupMenu = new PopupMenu.PopupBaseMenuItem();
      this.addMenuItem(vacantLeftPopupMenu);
      if (enableScaling)
      enableScalingFactorSupport(vacantLeftPopupMenu, scalingFactor);
      buildMenuWithLayoutIcon(
        _("Move to leftmost tile"),
        vacantLeftPopupMenu,
        [vacantTiles[0]],
        tiles,
        INNER_GAPS
      );
      vacantLeftPopupMenu.connect("activate", () => {
        OverriddenWindowMenu.get().emit(
          "tile-clicked",
          vacantTiles[0],
          window
        );
      });
      const tilesFromRightToLeft = vacantTiles.slice(0).sort((a, b) => b.x === a.x ? a.y - b.y : b.x - a.x);
      const vacantRightPopupMenu = new PopupMenu.PopupBaseMenuItem();
      this.addMenuItem(vacantRightPopupMenu);
      if (enableScaling)
      enableScalingFactorSupport(vacantRightPopupMenu, scalingFactor);
      buildMenuWithLayoutIcon(
        _("Move to rightmost tile"),
        vacantRightPopupMenu,
        [tilesFromRightToLeft[0]],
        tiles,
        INNER_GAPS
      );
      vacantRightPopupMenu.connect("activate", () => {
        OverriddenWindowMenu.get().emit(
          "tile-clicked",
          tilesFromRightToLeft[0],
          window
        );
      });
    }
    this.addMenuItem(new PopupMenu.PopupSeparatorMenuItem());
    const layoutsPopupMenu = new PopupMenu.PopupBaseMenuItem();
    this.addMenuItem(layoutsPopupMenu);
    const container = new St.BoxLayout({
      xAlign: Clutter.ActorAlign.START,
      yAlign: Clutter.ActorAlign.CENTER,
      xExpand: true,
      yExpand: true,
      style: "spacing: 16px !important",
      ...widgetOrientation(true)
    });
    layoutsPopupMenu.add_child(container);
    const layoutsPerRow = 4;
    const rows = [];
    for (let index = 0; index < layouts.length; index += layoutsPerRow) {
      const box = new St.BoxLayout({
        xAlign: Clutter.ActorAlign.CENTER,
        yAlign: Clutter.ActorAlign.CENTER,
        xExpand: true,
        yExpand: true,
        style: "spacing: 6px;"
      });
      rows.push(box);
      container.add_child(box);
    }
    if (enableScaling)
    enableScalingFactorSupport(layoutsPopupMenu, scalingFactor);
    const layoutHeight = 30;
    const layoutWidth = 52;
    layouts.forEach((lay, ind) => {
      const row = rows[Math.floor(ind / layoutsPerRow)];
      const layoutWidget = new LayoutTileButtons(
        row,
        lay,
        INNER_GAPS,
        layoutHeight,
        layoutWidth
      );
      layoutWidget.set_x_align(Clutter.ActorAlign.END);
      layoutWidget.buttons.forEach((btn) => {
        btn.connect("clicked", () => {
          OverriddenWindowMenu.get().emit(
            "tile-clicked",
            btn.tile,
            window
          );
          layoutsPopupMenu.activate(Clutter.get_current_event());
        });
      });
    });
  }
  static connect(key, func) {
    return this.get().connect(key, func) || -1;
  }
  static disconnect(id) {
    this.get().disconnect(id);
  }
};
__publicField(OverriddenWindowMenu, "metaInfo", {
  GTypeName: "OverriddenWindowMenu",
  Signals: {
    "tile-clicked": {
      param_types: [Tile.$gtype, Meta.Window.$gtype]
    }
  }
});
__publicField(OverriddenWindowMenu, "_instance", null);
__publicField(OverriddenWindowMenu, "_old_buildMenu");
__publicField(OverriddenWindowMenu, "_enabled", false);
OverriddenWindowMenu = __decorateClass([
registerGObjectClass],
OverriddenWindowMenu);