// For GNOME Shell version before 45
const Me = imports.misc.extensionUtils.getCurrentExtension();
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
  if (decorator = decorators[i])
  result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp(target, key, result);
  return result;
};
var registerGObjectClass = Me.imports.utils.gjs.registerGObjectClass;
var Clutter = Me.imports.gi.ext.Clutter;
var Layout = Me.imports.components.layout.Layout.Layout;
var buildRectangle = Me.imports.utils.ui.buildRectangle;
var Main = imports.ui.main;
var logger = Me.imports.utils.logger.logger;
var GlobalState = Me.imports.utils.globalState.GlobalState;
var SuggestedWindowPreview = Me.imports.components.windowsSuggestions.suggestedWindowPreview.SuggestedWindowPreview;
var Tile = Me.imports.components.layout.Tile.Tile;
var LayoutWidget = Me.imports.components.layout.LayoutWidget.LayoutWidget;
var SignalHandling = Me.imports.utils.signalHandling.SignalHandling;
var SuggestionsTilePreview = Me.imports.components.windowsSuggestions.suggestionsTilePreview.SuggestionsTilePreview;
var TilingShellWindowManager = Me.imports.components.windowManager.tilingShellWindowManager.TilingShellWindowManager;
var unmaximizeWindow = Me.imports.utils.gnomesupport.unmaximizeWindow;
var debug = logger("TilingLayoutWithSuggestions");
var ANIMATION_SPEED = 200;
var MASONRY_LAYOUT_ROW_HEIGHT = 0.31;
var TilingLayoutWithSuggestions = class extends LayoutWidget {
  _signals;
  _lastTiledWindow;
  _showing;
  _oldPreviews;
  constructor(innerGaps, outerGaps, containerRect, scalingFactor) {
    super({
      containerRect,
      parent: global.windowGroup,
      layout: new Layout([], ""),
      innerGaps,
      outerGaps,
      scalingFactor
    });
    this.canFocus = true;
    this.reactive = true;
    this._signals = new SignalHandling();
    this._lastTiledWindow = null;
    this._showing = false;
    this._oldPreviews = [];
    this.connect("destroy", () => this._signals.disconnect());
  }
  buildTile(parent, rect, gaps, tile) {
    return new SuggestionsTilePreview({
      parent,
      rect,
      gaps,
      tile
    });
  }
  open(tiledWindows, nontiledWindows, window, windowDesiredRect, monitorIndex) {
    if (this._showing) return;
    this._showing = true;
    this._lastTiledWindow = global.display.focusWindow;
    this._showVacantPreviewsOnly(tiledWindows, windowDesiredRect, window);
    this.show();
    this._recursivelyShowPopup(nontiledWindows, monitorIndex);
    this._signals.disconnect();
    this._signals.connect(this, "key-focus-out", () => this.close());
    this._signals.connect(this, "button-press-event", () => {
      this.close();
    });
    this._signals.connect(
      global.stage,
      "key-press-event",
      (_, event) => {
        const symbol = event.get_key_symbol();
        if (symbol === Clutter.KEY_Escape) this.close();
        return Clutter.EVENT_PROPAGATE;
      }
    );
  }
  _showVacantPreviewsOnly(tiledWindows, windowDesiredRect, window) {
    const vacantPreviews = this._previews.map((prev) => {
      const previewRect = buildRectangle({
        x: prev.innerX,
        y: prev.innerY,
        width: prev.innerWidth,
        height: prev.innerHeight
      });
      return !tiledWindows.find(
        (win) => previewRect.overlap(
          win === window ? windowDesiredRect : win.get_frame_rect()
        )
      );
    });
    const newPreviews = [];
    for (let index = 0; index < this._previews.length; index++) {
      if (vacantPreviews[index]) {
        this._previews[index].open();
        newPreviews.push(this._previews[index]);
      } else {
        this._previews[index].close();
        this._oldPreviews.push(this._previews[index]);
      }
    }
    this._previews = newPreviews;
  }
  _recursivelyShowPopup(nontiledWindows, monitorIndex) {
    if (this._previews.length === 0 || nontiledWindows.length === 0) {
      this.close();
      return;
    }
    let preview = this._previews[0];
    this._previews.forEach((prev) => {
      if (prev.x < preview.x) preview = prev;
    });
    const clones = nontiledWindows.map((nonTiledWin) => {
      const winClone = new SuggestedWindowPreview(nonTiledWin);
      const winActor = nonTiledWin.get_compositor_private();
      winActor.set_pivot_point(0.5, 0.5);
      if (!nonTiledWin.minimized) {
        winActor.ease({
          opacity: 0,
          duration: ANIMATION_SPEED,
          scaleX: 0.9,
          scaleY: 0.9,
          mode: Clutter.AnimationMode.EASE_OUT_QUAD,
          onComplete: () => {
            winActor.hide();
            winActor.set_pivot_point(0, 0);
          }
        });
      }
      winClone.connect("destroy", () => {
        if (nonTiledWin.minimized) {
          winActor.set_pivot_point(0, 0);
          return;
        }
        if (winActor.visible) return;
        winActor.set_pivot_point(0.5, 0.5);
        winActor.show();
        winActor.ease({
          opacity: 255,
          duration: ANIMATION_SPEED,
          scaleX: 1,
          scaleY: 1,
          mode: Clutter.AnimationMode.EASE_OUT_QUAD,
          onStopped: () => winActor.set_pivot_point(0, 0)
        });
      });
      winClone.connect("button-press-event", () => {
        this._lastTiledWindow = nonTiledWin;
        if (nonTiledWin.maximizedHorizontally || nonTiledWin.maximizedVertically)
        unmaximizeWindow(nonTiledWin);
        if (nonTiledWin.is_fullscreen())
        nonTiledWin.unmake_fullscreen();
        if (nonTiledWin.minimized) nonTiledWin.unminimize();
        const winRect = nonTiledWin.get_frame_rect();
        nonTiledWin.originalSize = winRect.copy();
        const cl = winClone.get_window_clone() ?? winClone;
        const [x, y] = cl.get_transformed_position();
        const allocation = cl.get_allocation_box();
        TilingShellWindowManager.easeMoveWindow({
          window: nonTiledWin,
          from: buildRectangle({
            x,
            y,
            width: allocation.x2 - allocation.x1,
            height: allocation.y2 - allocation.y1
          }),
          to: buildRectangle({
            x: preview.innerX,
            y: preview.innerY,
            width: preview.innerWidth,
            height: preview.innerHeight
          }),
          duration: ANIMATION_SPEED * 1.8,
          monitorIndex
        });
        nonTiledWin.assignedTile = new Tile({
          ...preview.tile
        });
        winClone.opacity = 0;
        const removed = this._previews.splice(
          this._previews.indexOf(preview),
          1
        );
        this._oldPreviews.push(...removed);
        nontiledWindows.splice(nontiledWindows.indexOf(nonTiledWin), 1);
        preview.close(true);
        this._recursivelyShowPopup(nontiledWindows, monitorIndex);
        return Clutter.EVENT_STOP;
      });
      return winClone;
    });
    preview.addWindows(
      clones,
      this._containerRect.height * MASONRY_LAYOUT_ROW_HEIGHT
    );
    clones.forEach((winClone) => {
      winClone.set_opacity(0);
      winClone.set_pivot_point(0.5, 0.5);
      winClone.set_scale(0.6, 0.6);
      winClone.ease({
        opacity: 255,
        duration: Math.floor(ANIMATION_SPEED * 1.8),
        scaleX: 1.03,
        scaleY: 1.03,
        mode: Clutter.AnimationMode.EASE_IN_OUT,
        onComplete: () => {
          winClone.ease({
            delay: 60,
            duration: Math.floor(ANIMATION_SPEED * 2.1),
            scaleX: 1,
            scaleY: 1,
            mode: Clutter.AnimationMode.EASE_IN_OUT
          });
        }
      });
    });
    this.grab_key_focus();
  }
  close() {
    if (!this._showing) return;
    this._showing = false;
    this._signals.disconnect();
    if (this._lastTiledWindow) Main.activateWindow(this._lastTiledWindow);
    this._previews.push(...this._oldPreviews);
    this._oldPreviews = [];
    this._previews.forEach((prev) => prev.removeAllWindows());
    this.ease({
      opacity: 0,
      duration: GlobalState.get().tilePreviewAnimationTime,
      mode: Clutter.AnimationMode.EASE_OUT_QUAD,
      onStopped: () => {
        this.hide();
        this._previews.forEach((prev) => prev.open());
      }
    });
  }
};
TilingLayoutWithSuggestions = __decorateClass([
registerGObjectClass],
TilingLayoutWithSuggestions);