import Gio from 'gi://Gio';
import Gtk4 from 'gi://Gtk';
import Gdk from 'gi://Gdk';
import GLib from 'gi://GLib';
import './node_modules/@girs/gnome-shell/dist/extensions/prefs.js';
import { ExtensionPreferences } from 'resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js';

class GnomeRectanglePreferences extends ExtensionPreferences {
    _settings;
    async fillPreferencesWindow(window) {
        const filepath = GLib.build_filenamev([this.path, 'resources', 'quick-lofi.gresource']);
        const resource = Gio.Resource.load(filepath);
        Gio.resources_register(resource);
        const iconTheme = Gtk4.IconTheme.get_for_display(Gdk.Display.get_default());
        iconTheme.add_resource_path('/org/gnome/Shell/Extensions/quick-lofi/icons');
        const { RadiosPage } = await import('./preferences/RadiosPage.js');
        const { PlayerPage } = await import('./preferences/PlayerPage.js');
        const { InterfacePage } = await import('./preferences/InterfacePage.js');
        this._settings = this.getSettings();
        window.connect('close-request', () => {
            this._settings = null;
        });
        window.add(new RadiosPage(this._settings, window));
        window.add(new PlayerPage(this._settings));
        window.add(new InterfacePage(this._settings));
    }
}

export { GnomeRectanglePreferences as default };
