/*
    Copyright 2025 Roman Lefler

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
let gettextFn = function (_) {
    throw new Error("Gettext not initialized");
};
/**
 * Sets up the gettext abstraction.
 * Import the correct gettext for the process and pass it into here.
 */
export function setUpGettext(gettext) {
    gettextFn = gettext;
}
/**
 * This is the normal GNU gettext function.
 * This function exists as an abstraction between the two imports for
 * extension.js and prefs.js, so the same code can be used in
 * both processes.
 */
export function gettext(str) {
    return gettextFn(str);
}
