import { Extension } from 'resource:///org/gnome/shell/extensions/extension.js';
import * as Main from 'resource:///org/gnome/shell/ui/main.js';

export default class ExampleExtension extends Extension {
  enable() {
    this._showingId = Main.overview.connect('showing', () => Main.panel.show());
    this._hidingId = Main.overview.connect('hiding', () => Main.panel.hide());
    // this._shownId = Main.overview.connect('shown', () => console.log("Overview is shown, animation ended"));
    // this._hiddenId = Main.overview.connect('hidden', () => console.log("Overview is hidden, animation ended"));

    // Initial state: hide if not in overview
    if (!Main.overview.visible) Main.panel.hide();
  }

  disable() {
    if (this._showingId) {
      Main.overview.disconnect(this._showingId);
      this._showingId = 0;
    }
    if (this._hidingId) {
      Main.overview.disconnect(this._hidingId);
      this._hidingId = 0;
    }

    Main.panel.show();
  }
}
