#!/usr/bin/env python3
import sys
from backend_detector import UniversalDetector

if len(sys.argv) < 2:
    print("", end="")
    sys.exit(1)

desktop_id = sys.argv[1]

try:
    detector = UniversalDetector()
    apps = detector.scan_applications()
    
    target = None
    for app in apps:
        # Chercher par desktop_id (ex: org.gnome.Calculator.desktop)
        if desktop_id in app.desktop_file or app.desktop_file.endswith(desktop_id):
            target = app
            break
    
    if target:
        cmd = detector.generate_uninstall_command(target)
        print(cmd, end="")
    else:
        print("", end="")
except Exception as e:
    print(f"Erreur: {e}", file=sys.stderr)
    print("", end="")
