import GObject from 'gi://GObject';
import ServiceTimer from './index.js';
export default class ServiceTimerHourly extends ServiceTimer {
    #done;
    static {
        GObject.registerClass(
            {
                GTypeName: 'DeskChangerServiceTimerHourly',
            },
            this
        );
    }

    constructor(callback) {
        super(5, callback);
        this.#done = false;
    }

    __callback__() {
        const date = new Date();
        if (date.getMinutes() === 0 && date.getSeconds() < 10 && !this.#done) {
            this.#done = true;
            return super.__callback__();
        }
        this.#done = false;
        return true;
    }
}
