import Adw from 'gi://Adw';
import GObject from 'gi://GObject';
import Gtk from 'gi://Gtk';
export default class KeyboardShortcutRow extends Adw.ActionRow {
    static {
        GObject.registerClass(
            {
                GTypeName: 'DeskChangerUiPrefsKeyboardShortcutRow',
                Properties: {
                    keybind: GObject.param_spec_string(
                        'keybind',
                        'Keybind',
                        '',
                        null,
                        GObject.ParamFlags.READABLE
                    ),
                },
            },
            this
        );
    }
    #accelerator_label;
    #binding;
    #keybind;
    #reset_button;

    get accelerator_label() {
        return this.#accelerator_label;
    }

    get keybind() {
        return this.#keybind;
    }

    constructor(keybind, accelerator, params) {
        super(params);
        this.#keybind = keybind;
        this.#accelerator_label = new Gtk.ShortcutLabel({
            disabled_text: 'Disabled',
        });
        this.#accelerator_label.accelerator = accelerator || '';
    }

    vfunc_realize() {
        super.vfunc_realize();
        const box = this.get_child() || null;
        if (!box) throw new TypeError('No child available');
        if (this.#accelerator_label) box.append(this.#accelerator_label);
        this.#reset_button = new Gtk.Button({label: 'Reset'});
        box.append(
            new Gtk.Revealer({
                child: this.#reset_button,
                transition_type: Gtk.RevealerTransitionType.SLIDE_RIGHT,
            })
        );
        this.set_activatable(true);
    }

    vfunc_unrealize() {
        if (this.#binding) {
            this.#binding.unbind();
            this.#binding = undefined;
        }
        this.#accelerator_label = undefined;
        this.#reset_button = undefined;
        super.vfunc_unrealize();
    }
}
