import Adw from 'gi://Adw';
import Gio from 'gi://Gio';
import GObject from 'gi://GObject';
import { handleErrorRow } from '../utils/helpers.js';
import { SETTINGS_KEYS, INDICATOR_ACTIONS_NAMES } from '../utils/constants.js';

class InterfacePage extends Adw.PreferencesPage {
    _settings;
    static {
        GObject.registerClass({
            GTypeName: 'InterfacePage',
            Template: 'resource:///org/gnome/Shell/Extensions/quick-lofi/preferences/InterfacePage.ui',
            InternalChildren: [
                'setPopupMaxHeightRow',
                'popupMaxHeightRow',
                'leftClickActionList',
                'middleClickActionList',
                'rightClickActionList',
                'leftClickRow',
                'middleClickRow',
                'rightClickRow',
            ],
        }, this);
    }
    _indicatorActionsNames;
    _indicatorActionsSettings;
    _handleApplyPopup(w) {
        const VALID_CSS_TYPES = ['px', 'pt', 'em', 'ex', 'rem', 'pc', 'in', 'cm', 'mm'];
        const regex = new RegExp(`^\\d+(\\.\\d+)?(${VALID_CSS_TYPES.join('|')})$`);
        if (!regex.test(w.text)) {
            const defaultValue = this._settings.get_default_value(SETTINGS_KEYS.POPUP_MAX_HEIGHT).get_string()[0];
            handleErrorRow(w, 'Invalid CSS value');
            w.set_text(defaultValue);
            this._settings.set_string(SETTINGS_KEYS.POPUP_MAX_HEIGHT, defaultValue);
            return;
        }
        this._settings.set_string(SETTINGS_KEYS.POPUP_MAX_HEIGHT, w.text);
    }
    _handleIndicatorActions() {
        const updateAction = ({ mouseBtn, actionIndex }) => {
            const actions = Array.from(this._indicatorActionsNames.keys());
            this._indicatorActionsSettings[mouseBtn] = actions[actionIndex];
            this._settings.set_strv(SETTINGS_KEYS.INDICATOR_ACTIONS, this._indicatorActionsSettings);
        };
        const setRowAction = ({ list, row, mouseBtn }) => {
            const actions = Array.from(this._indicatorActionsNames.values());
            for (const action of actions) {
                list.append(action);
            }
            const rowAction = actions[mouseBtn];
            const rowPosition = actions.indexOf(rowAction) + 1;
            row.set_selected(rowPosition);
            row.connect('notify::selected', () => {
                const newActionIndex = row.get_selected();
                updateAction({ mouseBtn, actionIndex: newActionIndex });
            });
        };
        setRowAction({ list: this._leftClickActionList, row: this._leftClickRow, mouseBtn: 0 });
        setRowAction({ list: this._middleClickActionList, row: this._middleClickRow, mouseBtn: 1 });
        setRowAction({ list: this._rightClickActionList, row: this._rightClickRow, mouseBtn: 2 });
    }
    constructor(_settings) {
        super();
        this._settings = _settings;
        this._indicatorActionsNames = INDICATOR_ACTIONS_NAMES;
        this._indicatorActionsSettings = this._settings.get_strv(SETTINGS_KEYS.INDICATOR_ACTIONS);
        this._settings.bind(SETTINGS_KEYS.POPUP_MAX_HEIGHT, this._popupMaxHeightRow, 'text', Gio.SettingsBindFlags.DEFAULT);
        this._settings.bind(SETTINGS_KEYS.SET_POPUP_MAX_HEIGHT, this._popupMaxHeightRow, 'visible', Gio.SettingsBindFlags.DEFAULT);
        this._settings.bind(SETTINGS_KEYS.SET_POPUP_MAX_HEIGHT, this._setPopupMaxHeightRow, 'active', Gio.SettingsBindFlags.DEFAULT);
        this._handleIndicatorActions();
    }
}

export { InterfacePage };
