import Adw from 'gi://Adw';
import Gio from 'gi://Gio';
import GObject from 'gi://GObject';
import { SHORTCUTS, SETTINGS_KEYS } from '../utils/constants.js';
import { ShortcutButton } from './ShortcutButton.js';

class PlayerPage extends Adw.PreferencesPage {
    _settings;
    static {
        GObject.registerClass({
            GTypeName: 'PlayerPage',
            Template: 'resource:///org/gnome/Shell/Extensions/quick-lofi/preferences/PlayerPage.ui',
            InternalChildren: ['volumeLevel', 'playerGroup'],
        }, this);
    }
    _handleShortcuts() {
        const shortcuts = [
            {
                settingsKey: SHORTCUTS.PLAY_PAUSE_SHORTCUT,
                title: 'Play or Pause',
                subtitle: 'Toggle playback of Quick Lofi.',
            },
            {
                settingsKey: SHORTCUTS.STOP_SHORTCUT,
                title: 'Stop Playback',
                subtitle: 'Stop Quick Lofi completely.',
            },
            {
                settingsKey: SHORTCUTS.INCREASE_VOLUME_SHORTCUT,
                title: 'Increase Volume',
                subtitle: 'Raise the volume by the system step.',
            },
            {
                settingsKey: SHORTCUTS.DECREASE_VOLUME_SHORTCUT,
                title: 'Decrease Volume',
                subtitle: 'Lower the volume by the system step.',
            },
        ];
        shortcuts.forEach((shortcut) => {
            const shortcutButton = new ShortcutButton(this._settings, shortcut.settingsKey);
            const shortcutRow = shortcutButton.createRow(shortcut.title, shortcut.subtitle);
            this._playerGroup.add(shortcutRow);
        });
    }
    constructor(_settings) {
        super();
        this._settings = _settings;
        this._settings.bind(SETTINGS_KEYS.VOLUME, this._volumeLevel, 'value', Gio.SettingsBindFlags.DEFAULT);
        this._handleShortcuts();
    }
}

export { PlayerPage };
