import GLib from 'gi://GLib';
import { SETTINGS_KEYS } from './constants.js';

function handleErrorRow(row, errorMessage) {
    const TIMEOUT_SECONDS = 3;
    const originalTitle = row.get_title();
    if (originalTitle === errorMessage)
        return;
    row.add_css_class('error');
    row.set_title(errorMessage);
    GLib.timeout_add_seconds(GLib.PRIORITY_HIGH, TIMEOUT_SECONDS, () => {
        row.set_title(originalTitle);
        row.remove_css_class('error');
        return GLib.SOURCE_REMOVE;
    });
}
function isCurrentRadioPlaying(settings, radioID) {
    const current = settings.get_string(SETTINGS_KEYS.CURRENT_RADIO_PLAYING);
    return current.length > 0 && current === radioID;
}
function generateNanoIdWithSymbols(size) {
    const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=[]{}|;:,.<>?';
    return Array.from({ length: size }, () => chars.charAt(Math.floor(Math.random() * chars.length))).join('');
}
function isUri(uri) {
    const scheme = GLib.uri_parse_scheme(uri);
    if (scheme) {
        return true;
    }
    return false;
}
function inspectItem(item) {
    const inspected = new Map();
    const keys = Object.keys(item);
    const values = Object.values(item);
    for (const index in keys) {
        const key = JSON.stringify(keys[index]);
        const value = JSON.stringify(values[index].toString());
        inspected.set(key, value);
    }
    return inspected;
}

export { generateNanoIdWithSymbols, handleErrorRow, inspectItem, isCurrentRadioPlaying, isUri };
