'use strict';

import Clutter from 'gi://Clutter';
import * as Config from 'resource:///org/gnome/shell/misc/config.js';
import Meta from 'gi://Meta';

export default class Cursor {
    constructor() {
        if (Config.PACKAGE_VERSION < 48) {
            this._tracker = Meta.CursorTracker.get_for_display(global.display);
        } else {
            this._tracker = global.backend.get_cursor_tracker();
        }

        // Track our own cursor visibility state to avoid double (un)inhibition
        this._hidden = false;
    }

    get hot() {
        return this._tracker.get_hot();
    }

    get sprite() {
        return this._tracker.get_sprite();
    }

    controlCursorVisibility(showCursor) {
        // Idempotent behavior: do nothing if state already matches
        if (showCursor && !this._hidden)
            return;
        if (!showCursor && this._hidden)
            return;

        if (Config.PACKAGE_VERSION < 49) {
            this._tracker.set_pointer_visible(showCursor);
        } else {
            if (showCursor)
                this._tracker.uninhibit_cursor_visibility();
            else
                this._tracker.inhibit_cursor_visibility();
        }

        this._hidden = !showCursor;
    }

    show() {
        const seat = Clutter.get_default_backend().get_default_seat();

        if (seat.is_unfocus_inhibited())
            seat.uninhibit_unfocus();

        this.controlCursorVisibility(true);
    }

    hide() {
        const seat = Clutter.get_default_backend().get_default_seat();

        if (!seat.is_unfocus_inhibited())
            seat.inhibit_unfocus();

        this.controlCursorVisibility(false);
    }

    destroy() {
        // Always restore cursor visibility on teardown
        this.controlCursorVisibility(true);
    }
}

