import * as Main from "resource:///org/gnome/shell/ui/main.js";
import { Extension } from "resource:///org/gnome/shell/extensions/extension.js";
import JetBrainsSearchProvider from "./provider.js";
export default class JetBrainsSearchProviderExtension extends Extension {
    provider = null;
    _settings = null;
    enable() {
        this._settings = this.getSettings();
        this.provider = new JetBrainsSearchProvider(this);
        Main.overview.searchController.addProvider(this.provider);
        if (this._settings?.get_boolean("override-results-order")) {
            const searchResults = Main.overview.searchController._searchResults;
            searchResults._content.remove_child(this.provider.display);
            searchResults._content.insert_child_at_index(this.provider.display, 1);
        }
    }
    disable() {
        this._settings = null;
        if (this.provider) {
            Main.overview.searchController.removeProvider(this.provider);
            this.provider = null;
        }
    }
}
