/* extension.js
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

import {Extension} from 'resource:///org/gnome/shell/extensions/extension.js';
import * as Main from 'resource:///org/gnome/shell/ui/main.js';

import {Indicator} from "./indicator.js";

export default class WeblingExtension extends Extension {
    constructor(metadata) {
        super(metadata);
    }

    enable() {
        console.info("Webling is starting...");

        this._settings = {
            sizepos: this.getSettings('org.gnome.shell.extensions.webling.sizes_and_positions'),
            toggles: this.getSettings('org.gnome.shell.extensions.webling.toggles')
        };

        this._indicator = new Indicator(this._settings);
        Main.panel.addToStatusArea(this.uuid, this._indicator);
    }

    disable() {
        console.info("Webling is exiting...");

        this._indicator?.destroy();
        this._indicator = null;

        this._settings.sizepos = null;
        this._settings.toggles = null;
        this._settings = null;
    }
}







