/**
 * VitalsConfig - Configuration types and constants
 *
 * Defines all configuration options and types for the extension
 */
/**
 * Available vital types
 */
export var VitalType;
(function (VitalType) {
    VitalType["CPU"] = "cpu";
    VitalType["RAM"] = "ram";
    VitalType["STORAGE"] = "storage";
    VitalType["TEMP"] = "temp";
    VitalType["GPU"] = "gpu";
})(VitalType || (VitalType = {}));
/**
 * Bar orientation options
 */
export var Orientation;
(function (Orientation) {
    Orientation["HORIZONTAL"] = "horizontal";
    Orientation["VERTICAL"] = "vertical";
})(Orientation || (Orientation = {}));
/**
 * Default configuration values
 */
export const DEFAULT_CONFIG = {
    // Position (percentage of screen)
    positionX: 85, // X position (0-100%)
    positionY: 50, // Y position (0-100%)
    // Appearance
    backgroundColor: 'rgba(0, 0, 0, 0.8)',
    borderColor: 'rgba(255, 255, 255, 0.2)',
    borderRadius: 12,
    vitalSpacing: 12,
    // Icons
    showIcons: true,
    iconColor: 'rgba(255, 255, 255, 0.9)',
    // Labels
    showLabels: true,
    // Vital visibility
    showCpu: true,
    showRam: true,
    showStorage: true,
    showTemp: true,
    showGpu: true,
    // Vital colors
    cpuColor: '#3498db',
    ramColor: '#2ecc71',
    storageColor: '#f39c12',
    tempColor: '#e74c3c',
    gpuColor: '#9b59b6',
    // ringsettings
    ringDiameter: 64, // Diameter of each circular progress
    ringWidth: 4, // Width of the progress ring
    // Update interval (ms)
    updateInterval: 2000,
    cpuUpdateInterval: 2000,
    ramUpdateInterval: 2000,
    storageUpdateInterval: 5000,
    tempUpdateInterval: 2000,
    gpuUpdateInterval: 2000,
};
//Helper to get vital display name
export function getVitalDisplayName(type) {
    const names = {
        [VitalType.CPU]: 'CPU',
        [VitalType.RAM]: 'RAM',
        [VitalType.STORAGE]: 'Storage',
        [VitalType.TEMP]: 'Temperature',
        [VitalType.GPU]: 'GPU',
    };
    return names[type];
}
//Helper to get default color for vital type
export function getDefaultColor(type) {
    return DEFAULT_CONFIG[`${type}Color`];
}
