const Main = imports.ui.main;
const Gio = imports.gi.Gio;

let signalId = null;
let openedOnce = false;

// Use GSettings to toggle animations
const settings = new Gio.Settings({ schema: 'org.gnome.desktop.interface' });

function enable() {
    if (openedOnce) return;

    if (Main.layoutManager._startingUp) {
        signalId = Main.layoutManager.connect('startup-complete', () => {
            Main.layoutManager.disconnect(signalId);
            signalId = null;
            openAppGridOnce();
        });
    } else {
        openAppGridOnce();
    }
}

function disable() {
    if (signalId) {
        Main.layoutManager.disconnect(signalId);
        signalId = null;
    }
}

function openAppGridOnce() {
    if (openedOnce) return;

    // Temporarily disable animations
    let prev = settings.get_boolean('enable-animations');
    settings.set_boolean('enable-animations', false);

    Main.overview.showApps();   // open app grid

    // Restore animations (optional: can delay slightly if needed)
    settings.set_boolean('enable-animations', prev);

    openedOnce = true;
}
