import Gio from 'gi://Gio';
import GLib from 'gi://GLib';

import * as Main from 'resource:///org/gnome/shell/ui/main.js';

let signalId = null;

// Desktop interface settings
const settings = new Gio.Settings({
    schema: 'org.gnome.desktop.interface',
});

// File that marks the extension has run once
const FLAG_FILE = GLib.build_filenamev([
    GLib.get_user_data_dir(),
    'appgridstartup_once',
]);

export function enable() {
    // If user enables manually, do nothing
    if (!Main.layoutManager._startingUp) {
        return;
    }

    // First startup: create flag, don't open grid
    if (!GLib.file_test(FLAG_FILE, GLib.FileTest.EXISTS)) {
        GLib.file_set_contents(FLAG_FILE, '1');
        return;
    }

    // Open grid only after startup completes
    signalId = Main.layoutManager.connect('startup-complete', () => {
        Main.layoutManager.disconnect(signalId);
        signalId = null;
        openAppGrid();
    });
}

export function disable() {
    if (signalId) {
        Main.layoutManager.disconnect(signalId);
        signalId = null;
    }
}

function openAppGrid() {
    const prev = settings.get_boolean('enable-animations');
    settings.set_boolean('enable-animations', false);

    Main.overview.showApps();

    settings.set_boolean('enable-animations', prev);
}
