const Main = imports.ui.main;
const Gio = imports.gi.Gio;
const GLib = imports.gi.GLib;

let signalId = null;
let settings = new Gio.Settings({ schema: 'org.gnome.desktop.interface' });

// File that marks the extension has run once
const FLAG_FILE = GLib.build_filenamev([GLib.get_user_data_dir(), 'appgridstartup_once']);

function enable() {
    // Only care about startup
    if (!Main.layoutManager._startingUp) {
        // User manually enabled → do nothing
        return;
    }

    // First-time startup → create the flag file but don't open grid
    if (!GLib.file_test(FLAG_FILE, GLib.FileTest.EXISTS)) {
        GLib.file_set_contents(FLAG_FILE, '1');
        return;
    }

    // Not first time → open grid after startup
    signalId = Main.layoutManager.connect('startup-complete', () => {
        Main.layoutManager.disconnect(signalId);
        signalId = null;
        actuallyOpenAppGrid();
    });
}

function disable() {
    if (signalId) {
        Main.layoutManager.disconnect(signalId);
        signalId = null;
    }
}

function actuallyOpenAppGrid() {
    let prev = settings.get_boolean('enable-animations');
    settings.set_boolean('enable-animations', false);

    Main.overview.showApps();

    settings.set_boolean('enable-animations', prev);
}

