import {Spin} from '../common.js';
import {Tile} from '../tile.js';
export default class SpinHandler {
    _spins;
    _windowManager;
    constructor(windowManager, extension) {
        this._windowManager = windowManager;
        this._spins = Spin.getSpins();
        this._spins.forEach(key => {
            extension._settings?.connect(`changed::${key}`, () => this._onSwitchChanged(key, extension));
        });
    }

    _onSwitchChanged(key, extension) {
        switch (key) {
        case 'tile-padding':
            if (extension.metadata && extension._settings?.get_int('tile-padding')) {
                Tile.padding = extension._settings.get_int('tile-padding');
                this._windowManager.updateMonitors();
            }
            break;
        default:
            break;
        }
    }
}
