import Gio from 'gi://Gio';
import GObject from 'gi://GObject';
import ServiceProfileWallpaper from './wallpaper.js';
export default class ServiceProfileQueue extends Gio.ListStore {
    static {
        GObject.registerClass(
            {
                GTypeName: 'DeskChangerServiceProfileQueue',
                Properties: {
                    next: GObject.param_spec_string(
                        'next',
                        'Next',
                        'Next item in queue object',
                        null,
                        GObject.ParamFlags.READABLE
                    ),
                },
            },
            this
        );
    }

    get items() {
        return Array.from({length: this.n_items}, (_, index) =>
            this.get_item(index)
        ).filter(value => value !== null && value !== undefined);
    }

    get next() {
        return this.get_item(0)?.wallpaper || null;
    }

    constructor() {
        super({item_type: ServiceProfileWallpaper.$gtype});
    }

    dequeue() {
        const item = this.get_item(0);
        if (!item) throw new TypeError(_('Failed to grab next queue item'));
        this.remove(0);
        return item;
    }
}
