import GObject from 'gi://GObject';
export default class ServiceProfileWallpaper extends GObject.Object {
    #wallpaper;
    static {
        GObject.registerClass(
            {
                GTypeName: 'DeskChangerServiceProfileWallpaper',
                Properties: {
                    wallpaper: GObject.param_spec_string(
                        'wallpaper',
                        'Wallpaper',
                        'Wallpaper URI',
                        null,
                        GObject.ParamFlags.READABLE
                    ),
                },
            },
            this
        );
    }

    get wallpaper() {
        return this.#wallpaper;
    }

    constructor(wallpaper) {
        super();
        this.#wallpaper = wallpaper;
    }

    toString() {
        return this.#wallpaper;
    }
}
